/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Constants;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ObjectiveC2_Property
implements StructConverter {
    private ObjectiveC2_State _state;
    private String name;
    private String attributes;

    public ObjectiveC2_Property(ObjectiveC2_State state, BinaryReader reader) throws IOException {
        this._state = state;
        long nameIndex = ObjectiveC1_Utilities.readNextIndex(reader, state.is32bit);
        this.name = reader.readAsciiString(nameIndex);
        long attributesIndex = ObjectiveC1_Utilities.readNextIndex(reader, state.is32bit);
        this.attributes = reader.readAsciiString(attributesIndex);
    }

    public String getName() {
        return this.name;
    }

    public String getAttributes() {
        return this.attributes;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("objc_property", 0);
        struct.add((DataType)new PointerDataType(ASCII), this._state.pointerSize, "name", null);
        struct.add((DataType)new PointerDataType(ASCII), this._state.pointerSize, "name", null);
        struct.setCategoryPath(ObjectiveC2_Constants.CATEGORY_PATH);
        return struct;
    }

    public void applyTo(Namespace namespace) {
    }
}

