/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.analysis;

import docking.DockingUtils;
import docking.options.editor.ScrollableOptionsEditor;
import generic.jar.ResourceFile;
import ghidra.app.services.Analyzer;
import ghidra.framework.analysis.AnalysisPhase;
import ghidra.framework.analysis.AnalysisRecipe;
import ghidra.framework.analysis.gui.AnalyzerListPanel;
import ghidra.framework.analysis.gui.GhidraScriptSelectionDialog;
import ghidra.framework.options.EditorStateFactory;
import ghidra.framework.options.Options;
import ghidra.util.layout.MiddleLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;

public class AnalysisRecipeEditor {
    private JComponent mainComponent;
    private AnalysisRecipe recipe;
    private JTextArea descriptionComponent;
    private JPanel analyzerOptionsPanel;
    private Analyzer selectedAnalyzer;
    private JPanel noOptionsPanel;
    private ChangeListener changeListener = e -> this.refresh();
    private JTabbedPane tabbedPane;
    private ChangeListener tabListener;

    public AnalysisRecipeEditor(AnalysisRecipe recipe) {
        this.recipe = recipe;
        this.mainComponent = this.buildComponent();
        recipe.setChangeListener(this.changeListener);
        this.buildNoOptionsPanel();
    }

    private void buildNoOptionsPanel() {
        this.noOptionsPanel = new JPanel((LayoutManager)new MiddleLayout());
        this.noOptionsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        JLabel label = new JLabel("No options available.");
        label.setFont(label.getFont().deriveFont(20.0f));
        this.noOptionsPanel.add(label);
    }

    private void refresh() {
        this.refreshAnalyzerPanel();
    }

    private JComponent buildComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.buildLeftPanel(), "West");
        panel.add(this.buildRightPanel(), "Center");
        panel.add(this.buildButtonPanel(), "South");
        return panel;
    }

    private Component buildButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout());
        JButton addScriptButton = new JButton("Add script");
        JButton addPhaseButton = new JButton("Add Phase");
        JButton removePhaseButton = new JButton("Remove Phase");
        addPhaseButton.addActionListener(e -> {
            if (this.recipe.getAnalysisPhases().size() < 9) {
                this.recipe.createPhase();
            }
        });
        removePhaseButton.addActionListener(e -> this.recipe.deletePhase());
        addScriptButton.addActionListener(e -> {
            GhidraScriptSelectionDialog dialog = new GhidraScriptSelectionDialog();
            ResourceFile file = (ResourceFile)dialog.show(this.mainComponent);
            if (file != null) {
                this.recipe.addScriptAnalyzer(file, dialog.getAnalyzerType(), dialog.getPriority());
            }
        });
        panel.add(addScriptButton);
        panel.add(addPhaseButton);
        panel.add(removePhaseButton);
        return panel;
    }

    private Component buildRightPanel() {
        this.analyzerOptionsPanel = new JPanel(new BorderLayout());
        this.configureBorder(this.analyzerOptionsPanel, "Analyzer Options");
        JSplitPane splitpane = new JSplitPane(0, this.buildDescriptionPanel(), this.analyzerOptionsPanel);
        splitpane.setResizeWeight(0.2);
        splitpane.setBorder(BorderFactory.createEmptyBorder(10, 6, 8, 6));
        splitpane.setDividerLocation(0.5);
        return splitpane;
    }

    private void configureBorder(JComponent component, String title) {
        Border emptyBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        TitledBorder titleBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(titleBorder, emptyBorder);
        component.setBorder(compoundBorder);
    }

    private JPanel buildDescriptionPanel() {
        this.descriptionComponent = this.buildTextArea();
        JScrollPane descriptionScrollPane = new JScrollPane(this.descriptionComponent);
        DockingUtils.setTransparent((JComponent)descriptionScrollPane);
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        this.configureBorder(descriptionScrollPane, "Analyzer Description");
        descriptionPanel.add((Component)descriptionScrollPane, "Center");
        return descriptionPanel;
    }

    private JTextArea buildTextArea() {
        JTextArea textarea = new JTextArea(3, 60);
        textarea.setEditable(false);
        textarea.setWrapStyleWord(true);
        textarea.setLineWrap(true);
        textarea.setFont(textarea.getFont().deriveFont(18.0f));
        return textarea;
    }

    private Component buildLeftPanel() {
        this.tabbedPane = new JTabbedPane();
        this.tabListener = e -> {
            AnalyzerListPanel panel = (AnalyzerListPanel)this.tabbedPane.getSelectedComponent();
            List<Analyzer> selectedAnalyzers = panel.getSelectedAnalyzers();
            this.setSelectedAnalyzer(selectedAnalyzers.size() == 1 ? selectedAnalyzers.get(0) : null);
        };
        this.populateTabs();
        this.tabbedPane.addChangeListener(this.tabListener);
        return this.tabbedPane;
    }

    private void populateTabs() {
        this.tabbedPane.addTab("All", new AnalyzerListPanel(this, this.recipe, null));
        List<AnalysisPhase> phases = this.recipe.getAnalysisPhases();
        for (int i = 0; i < phases.size(); ++i) {
            AnalysisPhase phase = phases.get(i);
            this.tabbedPane.addTab("Phase " + (i + 1), new AnalyzerListPanel(this, this.recipe, phase));
        }
        this.tabbedPane.setSelectedIndex(0);
    }

    private void refreshAnalyzerPanel() {
        this.tabbedPane.removeChangeListener(this.tabListener);
        List<AnalysisPhase> phases = this.recipe.getAnalysisPhases();
        int tabCount = this.tabbedPane.getTabCount();
        if (tabCount != phases.size() + 1) {
            this.tabbedPane.removeAll();
            this.populateTabs();
            return;
        }
        for (int i = 0; i < tabCount; ++i) {
            AnalyzerListPanel comp = (AnalyzerListPanel)this.tabbedPane.getComponentAt(i);
            comp.refresh();
        }
        this.tabbedPane.addChangeListener(this.tabListener);
        this.mainComponent.validate();
        this.mainComponent.repaint();
    }

    public JComponent getComponent() {
        return this.mainComponent;
    }

    public void setSelectedAnalyzer(Analyzer analyzer) {
        this.selectedAnalyzer = analyzer;
        String description = analyzer != null ? analyzer.getDescription() : "";
        this.descriptionComponent.setText(description);
        this.descriptionComponent.setCaretPosition(0);
        this.updateOptionsPanel();
        this.mainComponent.validate();
        this.analyzerOptionsPanel.repaint();
    }

    private void updateOptionsPanel() {
        this.analyzerOptionsPanel.removeAll();
        this.analyzerOptionsPanel.invalidate();
        if (this.selectedAnalyzer == null) {
            return;
        }
        Options options = this.recipe.getOptions(this.selectedAnalyzer);
        List optionNames = options.getLeafOptionNames();
        if (optionNames.isEmpty()) {
            this.analyzerOptionsPanel.add(this.noOptionsPanel);
            return;
        }
        ScrollableOptionsEditor editorPanel = new ScrollableOptionsEditor("Options For " + this.selectedAnalyzer.getName(), options, optionNames, new EditorStateFactory());
        editorPanel.setBorder(BorderFactory.createEmptyBorder());
        this.analyzerOptionsPanel.add((Component)editorPanel);
    }
}

