/*
 * Decompiled with CFR 0.152.
 */
package ghidra;

import generic.jar.ResourceFile;
import ghidra.framework.ApplicationProperties;
import ghidra.framework.GModule;
import ghidra.util.SystemUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import utility.application.ApplicationLayout;
import utility.application.ApplicationUtilities;
import utility.module.ModuleUtilities;

public class GhidraApplicationLayout
extends ApplicationLayout {
    public GhidraApplicationLayout() throws FileNotFoundException, IOException {
        this.applicationRootDirs = this.findGhidraApplicationRootDirs();
        this.applicationProperties = new ApplicationProperties(this.applicationRootDirs);
        this.applicationInstallationDir = this.findGhidraApplicationInstallationDir();
        this.modules = this.findGhidraModules();
        this.userTempDir = ApplicationUtilities.getDefaultUserTempDir(this.getApplicationProperties());
        this.userCacheDir = ApplicationUtilities.getDefaultUserCacheDir(this.getApplicationProperties());
        this.userSettingsDir = ApplicationUtilities.getDefaultUserSettingsDir(this.getApplicationProperties(), this.getApplicationInstallationDir());
        this.extensionInstallationDir = this.findExtensionInstallationDirectory();
        this.extensionArchiveDir = this.findExtensionArchiveDirectory();
    }

    public GhidraApplicationLayout(File applicationInstallationDir) throws FileNotFoundException, IOException {
        this.applicationInstallationDir = new ResourceFile(applicationInstallationDir);
        this.applicationRootDirs = Arrays.asList(new ResourceFile(this.applicationInstallationDir, "Ghidra"));
        this.applicationProperties = new ApplicationProperties(this.applicationRootDirs);
        this.modules = this.findGhidraModules();
        this.userTempDir = ApplicationUtilities.getDefaultUserTempDir(this.getApplicationProperties());
        this.userCacheDir = ApplicationUtilities.getDefaultUserCacheDir(this.getApplicationProperties());
        this.userSettingsDir = ApplicationUtilities.getDefaultUserSettingsDir(this.getApplicationProperties(), this.getApplicationInstallationDir());
    }

    protected Collection<ResourceFile> findGhidraApplicationRootDirs() {
        return ApplicationUtilities.findDefaultApplicationRootDirs();
    }

    protected ResourceFile findGhidraApplicationInstallationDir() {
        if (this.applicationRootDirs.isEmpty()) {
            return null;
        }
        ResourceFile dir = ((ResourceFile)this.applicationRootDirs.iterator().next()).getParentFile();
        if (SystemUtilities.isInDevelopmentMode()) {
            dir = dir.getParentFile();
        }
        return dir;
    }

    protected Map<String, GModule> findGhidraModules() throws IOException {
        String eclipseProjectDependencies;
        ResourceFile eclipseProjectDir;
        Collection<ResourceFile> moduleRootDirectories = ModuleUtilities.findModuleRootDirectories(this.applicationRootDirs, new ArrayList<ResourceFile>());
        String eclipseProjectDirProperty = System.getProperty("eclipse.project.dir");
        if (eclipseProjectDirProperty != null && !eclipseProjectDirProperty.isEmpty() && ModuleUtilities.isModuleDirectory(eclipseProjectDir = new ResourceFile(eclipseProjectDirProperty))) {
            moduleRootDirectories.add(eclipseProjectDir);
        }
        if ((eclipseProjectDependencies = System.getProperty("eclipse.project.dependencies")) != null && !eclipseProjectDependencies.isEmpty()) {
            for (String path : eclipseProjectDependencies.split(File.pathSeparator)) {
                ResourceFile eclipseProjectDir2 = new ResourceFile(path);
                if (!ModuleUtilities.isModuleDirectory(eclipseProjectDir2)) continue;
                moduleRootDirectories.add(eclipseProjectDir2);
            }
        }
        return ModuleUtilities.findModules(this.applicationRootDirs, moduleRootDirectories);
    }

    protected ResourceFile findExtensionArchiveDirectory() {
        if (SystemUtilities.isInDevelopmentMode()) {
            return null;
        }
        if (this.applicationInstallationDir == null) {
            return null;
        }
        return new ResourceFile(this.applicationInstallationDir, "Extensions/Ghidra");
    }

    protected ResourceFile findExtensionInstallationDirectory() {
        if (SystemUtilities.isInDevelopmentMode()) {
            ResourceFile rootDir = this.getApplicationRootDirs().iterator().next();
            File temp = new File(rootDir.getFile(false), "Extensions");
            if (temp.exists()) {
                return new ResourceFile(temp);
            }
            return null;
        }
        ResourceFile installDir = this.findGhidraApplicationInstallationDir();
        return new ResourceFile(installDir, "Ghidra/Extensions");
    }
}

