/*
 * Decompiled with CFR 0.152.
 */
package docking.action;

import docking.ActionContext;
import docking.DockingActionManager;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyEntryDialog;
import docking.action.MenuData;
import ghidra.util.Msg;
import ghidra.util.ReservedKeyBindings;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;

public class KeyBindingAction
extends DockingAction {
    private final DockingActionManager dockingActionManager;

    public KeyBindingAction(DockingActionManager dockingActionManager) {
        super("Set KeyBinding", "DockingWindows");
        this.dockingActionManager = dockingActionManager;
        this.createReservedKeyBinding(ReservedKeyBindings.UPDATE_KEY_BINDINGS_KEY);
        this.setEnabled(true);
        DockingWindowManager.getHelpService().excludeFromHelp(this);
    }

    @Override
    public void actionPerformed(ActionContext context) {
        DockingWindowManager windowManager = DockingWindowManager.getActiveInstance();
        if (windowManager == null) {
            return;
        }
        DockingActionIf action = DockingWindowManager.getMouseOverAction();
        if (action == null) {
            return;
        }
        if (!(action = this.maybeGetToolLevelAction(action)).isKeyBindingManaged()) {
            Component parent = windowManager.getActiveComponent();
            Msg.showInfo(this.getClass(), (Component)parent, (String)"Unable to Set Keybinding", (Object)("Action \"" + this.getActionName(action) + "\" is not keybinding managed and thus a keybinding cannot be set."));
            return;
        }
        KeyEntryDialog d = new KeyEntryDialog(action, this.dockingActionManager);
        DockingWindowManager.showDialog(d);
    }

    private DockingActionIf maybeGetToolLevelAction(DockingActionIf dockingAction) {
        if (dockingAction.isKeyBindingManaged()) {
            return dockingAction;
        }
        String actionToolName = dockingAction.getName() + " (Tool)";
        List<DockingActionIf> actions = this.dockingActionManager.getAllDockingActionsByFullActionName(actionToolName);
        Iterator<DockingActionIf> iterator = actions.iterator();
        if (iterator.hasNext()) {
            DockingActionIf action = iterator.next();
            return action;
        }
        return dockingAction;
    }

    private String getActionName(DockingActionIf action) {
        MenuData popupMenuData = action.getPopupMenuData();
        if (popupMenuData != null) {
            return popupMenuData.getMenuItemName();
        }
        MenuData menuBarData = action.getMenuBarData();
        if (menuBarData != null) {
            return menuBarData.getMenuItemName();
        }
        return action.getName();
    }

    @Override
    public boolean isEnabledForContext(ActionContext context) {
        return true;
    }
}

