/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import db.DBBuffer;
import db.DBHandle;
import db.Record;
import db.Table;
import ghidra.program.database.map.AddressMapDB;
import ghidra.program.database.mem.MemoryBlockDB;
import ghidra.program.database.mem.MemoryMapDB;
import ghidra.program.database.mem.MemoryMapDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

class MemoryMapDBAdapterV0
extends MemoryMapDBAdapter {
    static final String V0_TABLE_NAME = "Memory Block";
    private static final int VERSION = 0;
    protected static final int V0_NAME_COL = 0;
    protected static final int V0_BUFFER_ID_COL = 1;
    protected static final int V0_COMMENTS_COL = 2;
    protected static final int V0_DESCRIPTION_COL = 3;
    protected static final int V0_SOURCE_NAME_COL = 4;
    protected static final int V0_SOURCE_OFFSET_COL = 5;
    protected static final int V0_IS_READ_COL = 6;
    protected static final int V0_IS_WRITE_COL = 7;
    protected static final int V0_IS_EXECUTE_COL = 8;
    protected static final int V0_START_ADDR_COL = 9;
    protected static final int V0_LENGTH_COL = 10;
    protected static final int V0_TYPE_COL = 11;
    protected static final int V0_BASE_ADDR_COL = 12;
    protected static final int V0_SOURCE_BLOCK_ID_COL = 13;
    protected static final int V0_SEGMENT_COL = 14;
    private MemoryBlockDB[] blocks;
    private DBHandle handle;

    MemoryMapDBAdapterV0(DBHandle handle, MemoryMapDB memMap) throws VersionException, IOException {
        this(handle, memMap, 0);
    }

    protected MemoryMapDBAdapterV0(DBHandle handle, MemoryMapDB memMap, int expectedVersion) throws VersionException, IOException {
        this.handle = handle;
        AddressMapDB addrMap = memMap.getAddressMap();
        Table table = handle.getTable(V0_TABLE_NAME);
        if (table == null) {
            throw new VersionException("Memory Block table not found");
        }
        int versionNumber = table.getSchema().getVersion();
        if (versionNumber != expectedVersion) {
            throw new VersionException("Memory Block table: Expected Version " + expectedVersion + ", got " + versionNumber);
        }
        int recCount = table.getRecordCount();
        this.blocks = new MemoryBlockDB[recCount];
        AddressFactory addrFactory = memMap.getAddressFactory();
        int i = 0;
        for (Record rec : table) {
            int permissions = 0;
            if (rec.getBooleanValue(6)) {
                permissions |= 4;
            }
            if (rec.getBooleanValue(7)) {
                permissions |= 2;
            }
            if (rec.getBooleanValue(8)) {
                permissions |= 1;
            }
            Address start = addrFactory.oldGetAddressFromLong(rec.getLongValue(9));
            long startAddr = addrMap.getKey(start, false);
            long overlayAddr = rec.getLongValue(12);
            try {
                Address ov = addrFactory.oldGetAddressFromLong(overlayAddr);
                overlayAddr = addrMap.getKey(ov, false);
            }
            catch (Exception ov) {
                // empty catch block
            }
            int segment = 0;
            if (expectedVersion == 1 && start instanceof SegmentedAddress) {
                segment = rec.getIntValue(14);
            }
            Record blockRec = MemoryMapDBAdapter.BLOCK_SCHEMA.createRecord((long)i);
            blockRec.setString(0, rec.getString(0));
            blockRec.setString(1, rec.getString(2));
            blockRec.setString(2, rec.getString(4));
            blockRec.setByteValue(3, (byte)permissions);
            blockRec.setLongValue(4, startAddr);
            blockRec.setShortValue(5, rec.getShortValue(11));
            blockRec.setLongValue(6, overlayAddr);
            blockRec.setLongValue(7, rec.getLongValue(10));
            blockRec.setIntValue(8, rec.getIntValue(1));
            blockRec.setIntValue(9, segment);
            this.blocks[i++] = MemoryMapDBAdapter.getMemoryBlock(this, blockRec, null, memMap);
        }
        Arrays.sort(this.blocks);
    }

    @Override
    void refreshMemory() throws IOException {
    }

    @Override
    MemoryBlockDB[] getMemoryBlocks() {
        return this.blocks;
    }

    @Override
    MemoryBlockDB splitBlock(MemoryBlockDB block, long offset) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    MemoryBlockDB createInitializedBlock(String name, Address startAddr, InputStream is, long length, int permissions) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    MemoryBlockDB createInitializedBlock(String name, Address startAddr, DBBuffer buf, int permissions) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    MemoryBlockDB joinBlocks(MemoryBlockDB block1, MemoryBlockDB block2) throws IOException {
        throw new UnsupportedOperationException();
    }

    void setBlockSize(MemoryBlockDB block, long size) {
        throw new UnsupportedOperationException();
    }

    @Override
    void deleteMemoryBlock(MemoryBlockDB block) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void deleteTable(DBHandle dbHandle) throws IOException {
        dbHandle.deleteTable(V0_TABLE_NAME);
    }

    @Override
    void updateBlockRecord(Record record) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    DBBuffer createBuffer(int length, byte initialValue) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    MemoryBlockDB createBlock(MemoryBlockType blockType, String name, Address startAddr, long length, Address overlayAddr, boolean initializeBytes, int permissions) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    DBBuffer getBuffer(int bufferID) throws IOException {
        if (bufferID >= 0) {
            return this.handle.getBuffer(bufferID);
        }
        return null;
    }
}

