/*
 * Decompiled with CFR 0.152.
 */
package generic.jar;

import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.util.exception.AssertException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import utility.module.ModuleManifestFile;

public class ApplicationModule
implements Comparable<ApplicationModule> {
    private File moduleDir;
    private String relativePath;
    private File applicationRoot;

    public ApplicationModule(File applicationRoot, File moduleDir) {
        this.applicationRoot = applicationRoot;
        this.moduleDir = moduleDir;
        String filePath = moduleDir.getAbsolutePath();
        String rootPath = applicationRoot.getAbsolutePath();
        if (!filePath.startsWith(rootPath)) {
            throw new AssertException("ApplicationRoot is not in the parent path of moduleDir!");
        }
        this.relativePath = filePath.substring(rootPath.length() + 1);
    }

    public String getName() {
        return this.moduleDir.getName();
    }

    public File getModuleDir() {
        return this.moduleDir;
    }

    public File getApplicationRoot() {
        return this.applicationRoot;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public boolean isExtension() {
        return this.moduleDir.getParentFile().getName().equalsIgnoreCase("Extensions");
    }

    public boolean isFramework() {
        return this.moduleDir.getParentFile().getName().equalsIgnoreCase("Framework");
    }

    public boolean isProcessor() {
        return this.moduleDir.getParentFile().getName().equalsIgnoreCase("Processors");
    }

    public boolean isFeature() {
        return this.moduleDir.getParentFile().getName().equalsIgnoreCase("Features");
    }

    public boolean isConfiguration() {
        return this.moduleDir.getParentFile().getName().equalsIgnoreCase("Configurations");
    }

    public boolean isGPL() {
        return this.moduleDir.getParentFile().getName().equalsIgnoreCase("GPL");
    }

    @Override
    public int compareTo(ApplicationModule o) {
        int otherRank;
        int myRank = this.getRank();
        int result = myRank - (otherRank = o.getRank());
        if (result == 0) {
            result = this.getName().compareTo(o.getName());
        }
        return result;
    }

    public String toString() {
        return this.getName();
    }

    private int getRank() {
        if (this.getName().equals("RenoirGraph")) {
            return 10;
        }
        if (this.isFramework()) {
            return 1;
        }
        if (this.isFeature()) {
            return 2;
        }
        if (this.isProcessor()) {
            return 3;
        }
        return 4;
    }

    public boolean excludeFromGhidraJar() {
        try {
            Collection<ResourceFile> applicationRoots = Application.getApplicationRootDirectories();
            HashSet<File> rootDirParents = new HashSet<File>();
            for (ResourceFile root : applicationRoots) {
                rootDirParents.add(root.getParentFile().getFile(true));
            }
            ModuleManifestFile moduleManifestFile = new ModuleManifestFile(this.moduleDir);
            return moduleManifestFile.excludeFromGhidraJar();
        }
        catch (IOException e) {
            return false;
        }
    }
}

