/*
 * Decompiled with CFR 0.152.
 */
package generic.platform;

import generic.platform.AbstractMacHandler;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.util.Msg;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.lang3.reflect.MethodUtils;

public abstract class MacQuitHandler
extends AbstractMacHandler {
    public MacQuitHandler() {
        this.addQuitApplicationListener(this);
    }

    public abstract void quit();

    private void addQuitApplicationListener(MacQuitHandler macQuitHandler) {
        if (Platform.CURRENT_PLATFORM.getOperatingSystem() != OperatingSystem.MAC_OS_X) {
            return;
        }
        try {
            Object application = this.getApplication();
            this.setQuitHandler(application);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)"Unable to install Mac quit handler", (Throwable)e);
        }
    }

    private void setQuitHandler(Object application) throws Exception {
        Class<?> quitHandlerClass = Class.forName("com.apple.eawt.QuitHandler");
        Object quitHandler = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{quitHandlerClass}, (InvocationHandler)this);
        MethodUtils.invokeMethod((Object)application, (String)"setQuitHandler", (Object[])new Object[]{quitHandler});
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object response = args[1];
        MethodUtils.invokeExactMethod((Object)response, (String)"cancelQuit");
        this.quit();
        return null;
    }
}

