/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.correlator.program;

import ghidra.app.plugin.prototype.match.MatchData;
import ghidra.app.plugin.prototype.match.MatchedData;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMatchInfo;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTScore;
import ghidra.feature.vt.api.util.VTAbstractProgramCorrelator;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class DataMatchProgramCorrelator
extends VTAbstractProgramCorrelator {
    private final String name;
    private final boolean oneToOne;

    public DataMatchProgramCorrelator(ServiceProvider serviceProvider, Program sourceProgram, AddressSetView sourceAddressSet, Program destinationProgram, AddressSetView destinationAddressSet, ToolOptions options, String name, boolean oneToOne) {
        super(serviceProvider, sourceProgram, sourceAddressSet, destinationProgram, destinationAddressSet, options);
        this.name = name;
        this.oneToOne = oneToOne;
    }

    @Override
    protected void doCorrelate(VTMatchSet matchSet, TaskMonitor monitor) throws CancelledException {
        int dataMinimumSize = this.getOptions().getInt("Data Minimum Size", 5);
        int dataMaximumSize = this.getOptions().getInt("Data Maximum Size", 0x100000);
        int dataAlignment = this.getOptions().getInt("Data Alignment", 1);
        boolean skipHomogenousData = this.getOptions().getBoolean("Skip Homogenous Data", true);
        List matchedDataList = MatchData.matchData((Program)this.getSourceProgram(), (AddressSetView)this.getSourceAddressSet(), (Program)this.getDestinationProgram(), (AddressSetView)this.getDestinationAddressSet(), (int)dataMinimumSize, (int)dataMaximumSize, (int)dataAlignment, (boolean)skipHomogenousData, (boolean)this.oneToOne, (!this.oneToOne ? 1 : 0) != 0, (TaskMonitor)monitor);
        monitor.initialize((long)matchedDataList.size());
        monitor.setMessage("Finally, adding " + matchedDataList.size() + " match objects...");
        int skipAmount = 1000;
        int count = 0;
        for (MatchedData matchedData : matchedDataList) {
            if (++count % 1000 == 0) {
                if (monitor.isCancelled()) break;
                monitor.incrementProgress(1000L);
            }
            VTMatchInfo matchInfo = this.generateMatchFromMatchedData(matchSet, matchedData);
            matchSet.addMatch(matchInfo);
        }
    }

    private VTMatchInfo generateMatchFromMatchedData(VTMatchSet matchSet, MatchedData matchedData) {
        Address sourceAddress = matchedData.getADataAddress();
        Address destinationAddress = matchedData.getBDataAddress();
        VTScore similarity = new VTScore(1.0);
        VTScore confidence = new VTScore(10.0 / (double)(matchedData.getBMatchNum() * matchedData.getAMatchNum()));
        Data sourceData = matchedData.getAData();
        int sourceLength = sourceData.getLength();
        VTMatchInfo matchInfo = new VTMatchInfo(matchSet);
        matchInfo.setSimilarityScore(similarity);
        matchInfo.setConfidenceScore(confidence);
        matchInfo.setSourceLength(sourceLength);
        matchInfo.setSourceAddress(sourceAddress);
        matchInfo.setDestinationLength(sourceLength);
        matchInfo.setDestinationAddress(destinationAddress);
        matchInfo.setTag(null);
        matchInfo.setAssociationType(VTAssociationType.DATA);
        return matchInfo;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

