/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.util.AddEditDialog;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.util.Msg;
import java.awt.Component;

public class RenameFunctionAction
extends DockingAction {
    private final DecompilerController controller;
    private final PluginTool tool;

    public RenameFunctionAction(String owner, PluginTool tool, DecompilerController controller) {
        super("Rename Function", owner);
        this.tool = tool;
        this.controller = controller;
        this.setKeyBindingData(new KeyBindingData(76, 0));
        this.setPopupMenuData(new MenuData(new String[]{"Rename Function"}, "Decompile"));
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DecompilerActionContext)) {
            return false;
        }
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            return true;
        }
        return this.getFunction() != null;
    }

    public void actionPerformed(ActionContext context) {
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)context.getComponentProvider().getComponent(), (String)"Decompiler Action Blocked", (Object)"You cannot perform Decompiler actions while the Decompiler is busy");
            return;
        }
        Function function = this.getFunction();
        AddEditDialog dialog = new AddEditDialog("Edit Function Name", this.tool);
        dialog.editLabel(function.getSymbol(), this.controller.getProgram());
    }

    private Function getFunction() {
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        if (tokenAtCursor instanceof ClangFuncNameToken) {
            return DecompilerUtils.getFunction(this.controller.getProgram(), (ClangFuncNameToken)tokenAtCursor);
        }
        return null;
    }
}

