/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyFile;
import org.jruby.ir.IRScope;
import org.jruby.org.objectweb.asm.ClassReader;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.JRubyFile;
import org.jruby.util.OneShotClassLoader;

public class CompiledScriptLoader {
    public static IRScope loadScriptFromFile(Ruby runtime, InputStream inStream, File resourcePath, String resourceName, boolean isAbsolute) {
        String name2 = CompiledScriptLoader.getFilenameFromPathAndName(resourcePath, resourceName, isAbsolute);
        try {
            Class clazz = CompiledScriptLoader.loadCompiledScriptFromClass(runtime, inStream);
            try {
                Method method = clazz.getMethod("loadIR", Ruby.class, String.class);
                IRScope iRScope = (IRScope)method.invoke(null, runtime, name2);
                return iRScope;
            }
            catch (Exception e) {
                try {
                    if (runtime.getDebug().isTrue()) {
                        e.printStackTrace();
                    }
                    throw runtime.newLoadError(name2 + " is not compiled Ruby; use java_import to load normal classes");
                }
                catch (IOException e2) {
                    throw runtime.newIOErrorFromException(e2);
                }
                catch (LinkageError le) {
                    if (runtime.getDebug().isTrue()) {
                        le.printStackTrace();
                    }
                    throw runtime.newLoadError("Linkage error loading compiled script; you may need to recompile '" + name2 + "': " + le);
                }
            }
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException ioe) {
                throw runtime.newIOErrorFromException(ioe);
            }
        }
    }

    private static Class loadCompiledScriptFromClass(Ruby runtime, InputStream in) throws IOException {
        int read2;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        while ((read2 = in.read(buf)) != -1) {
            baos.write(buf, 0, read2);
        }
        buf = baos.toByteArray();
        JRubyClassLoader jcl = runtime.getJRubyClassLoader();
        OneShotClassLoader oscl = new OneShotClassLoader(jcl);
        ClassReader cr = new ClassReader(buf);
        String className = cr.getClassName().replace('/', '.');
        return oscl.defineClass(className, buf);
    }

    public static String getFilenameFromPathAndName(File resourcePath, String resourceName, boolean isAbsolute) {
        String name2 = JRubyFile.normalizeSeps(resourceName);
        File path2 = resourcePath;
        if (path2 != null && !isAbsolute) {
            name2 = JRubyFile.normalizeSeps(RubyFile.canonicalize(path2.getPath()));
        }
        return name2;
    }
}

