/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device.script.helper;

import java.io.IOException;
import java.util.Map;
import onl.netfishers.netshot.device.access.Snmp;
import onl.netfishers.netshot.device.credentials.DeviceSnmpCommunity;
import onl.netfishers.netshot.work.TaskLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsSnmpHelper {
    private static Logger logger = LoggerFactory.getLogger(JsSnmpHelper.class);
    private Snmp poller;
    protected DeviceSnmpCommunity community;
    private TaskLogger taskLogger;
    private boolean errored = false;

    public JsSnmpHelper(Snmp poller, DeviceSnmpCommunity community, TaskLogger taskLogger) {
        this.poller = poller;
        this.community = community;
        this.taskLogger = taskLogger;
    }

    public boolean isErrored() {
        return this.errored;
    }

    public String getAsString(String oid) throws IOException {
        try {
            return this.poller.getAsString(oid);
        }
        catch (IOException e) {
            logger.error("SNMP I/O error.", e);
            this.taskLogger.error("I/O error: " + e.getMessage());
            throw e;
        }
    }

    public Map<String, String> walkAsString(String oid) throws IOException {
        try {
            return this.poller.walkAsString(oid);
        }
        catch (IOException e) {
            logger.error("SNMP I/O error.", e);
            this.taskLogger.error("I/O error: " + e.getMessage());
            throw e;
        }
    }

    public void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

