/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.DefaultType;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Namespace;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.NamespaceList;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Order;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Root;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Commit;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Complete;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ConstructorScanner;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Decorator;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Detail;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Function;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.MethodDetail;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.NamespaceDecorator;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ParameterMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Persist;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Replace;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Resolve;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Signature;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Support;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Validate;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

class ClassScanner {
    private NamespaceDecorator decorator;
    private ConstructorScanner scanner;
    private Function commit;
    private Function validate;
    private Function persist;
    private Function complete;
    private Function replace;
    private Function resolve;
    private Support support;
    private Root root;
    private Order order;

    public ClassScanner(Detail detail, Support support) {
        this.scanner = new ConstructorScanner(detail, support);
        this.decorator = new NamespaceDecorator();
        this.support = support;
        this.scan(detail);
    }

    public Signature getSignature() {
        return this.scanner.getSignature();
    }

    public List getSignatures() {
        return this.scanner.getSignatures();
    }

    public ParameterMap getParameters() {
        return this.scanner.getParameters();
    }

    public Decorator getDecorator() {
        return this.decorator;
    }

    public Order getOrder() {
        return this.order;
    }

    public Root getRoot() {
        return this.root;
    }

    public Function getCommit() {
        return this.commit;
    }

    public Function getValidate() {
        return this.validate;
    }

    public Function getPersist() {
        return this.persist;
    }

    public Function getComplete() {
        return this.complete;
    }

    public Function getReplace() {
        return this.replace;
    }

    public Function getResolve() {
        return this.resolve;
    }

    private void scan(Detail detail) {
        DefaultType defaultType = detail.getOverride();
        Class clazz = detail.getType();
        while (clazz != null) {
            Detail detail2 = this.support.getDetail(clazz, defaultType);
            this.namespace(detail2);
            this.method(detail2);
            this.definition(detail2);
            clazz = detail2.getSuper();
        }
        this.commit(detail);
    }

    private void definition(Detail detail) {
        if (this.root == null) {
            this.root = detail.getRoot();
        }
        if (this.order == null) {
            this.order = detail.getOrder();
        }
    }

    private void namespace(Detail detail) {
        NamespaceList namespaceList = detail.getNamespaceList();
        Namespace namespace = detail.getNamespace();
        if (namespace != null) {
            this.decorator.add(namespace);
        }
        if (namespaceList != null) {
            Namespace[] namespaceArray;
            for (Namespace namespace2 : namespaceArray = namespaceList.value()) {
                this.decorator.add(namespace2);
            }
        }
    }

    private void commit(Detail detail) {
        Namespace namespace = detail.getNamespace();
        if (namespace != null) {
            this.decorator.set(namespace);
        }
    }

    private void method(Detail detail) {
        List list = detail.getMethods();
        for (MethodDetail methodDetail : list) {
            this.method(methodDetail);
        }
    }

    private void method(MethodDetail methodDetail) {
        Annotation[] annotationArray = methodDetail.getAnnotations();
        Method method = methodDetail.getMethod();
        for (Annotation annotation : annotationArray) {
            if (annotation instanceof Commit) {
                this.commit(method);
            }
            if (annotation instanceof Validate) {
                this.validate(method);
            }
            if (annotation instanceof Persist) {
                this.persist(method);
            }
            if (annotation instanceof Complete) {
                this.complete(method);
            }
            if (annotation instanceof Replace) {
                this.replace(method);
            }
            if (!(annotation instanceof Resolve)) continue;
            this.resolve(method);
        }
    }

    private void replace(Method method) {
        if (this.replace == null) {
            this.replace = this.getFunction(method);
        }
    }

    private void resolve(Method method) {
        if (this.resolve == null) {
            this.resolve = this.getFunction(method);
        }
    }

    private void commit(Method method) {
        if (this.commit == null) {
            this.commit = this.getFunction(method);
        }
    }

    private void validate(Method method) {
        if (this.validate == null) {
            this.validate = this.getFunction(method);
        }
    }

    private void persist(Method method) {
        if (this.persist == null) {
            this.persist = this.getFunction(method);
        }
    }

    private void complete(Method method) {
        if (this.complete == null) {
            this.complete = this.getFunction(method);
        }
    }

    private Function getFunction(Method method) {
        boolean bl = this.isContextual(method);
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return new Function(method, bl);
    }

    private boolean isContextual(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length == 1) {
            return Map.class.equals(classArray[0]);
        }
        return false;
    }
}

