/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocSet;

abstract class GraphEdgeCollector
extends SimpleCollector
implements Collector {
    DocSet skipSet;
    DocSet leafNodes;
    int numHits = 0;
    BitSet bits;
    int base;
    SchemaField collectField;

    GraphEdgeCollector(SchemaField collectField, DocSet skipSet, DocSet leafNodes) {
        this.collectField = collectField;
        this.skipSet = skipSet;
        this.leafNodes = leafNodes;
    }

    public void setCollectDocs(FixedBitSet target) {
        this.bits = target;
    }

    public int getNumHits() {
        return this.numHits;
    }

    public void collect(int segDoc) throws IOException {
        int doc = segDoc + this.base;
        if (this.skipSet != null && this.skipSet.exists(doc)) {
            return;
        }
        if (this.bits != null) {
            this.bits.set(doc);
        }
        ++this.numHits;
        if (this.leafNodes == null || !this.leafNodes.exists(doc)) {
            this.addEdgeIdsToResult(segDoc);
        }
    }

    abstract void addEdgeIdsToResult(int var1) throws IOException;

    private void addDocToResult(int docWithBase) {
        this.bits.set(docWithBase);
        ++this.numHits;
    }

    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.base = context.docBase;
    }

    public abstract Query getResultQuery(SchemaField var1, boolean var2);

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }
}

