/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SortField;
import org.apache.solr.common.SolrException;
import org.apache.solr.request.SolrRequestInfo;

class TestValueSource
extends ValueSource {
    ValueSource source;

    public TestValueSource(ValueSource source) {
        this.source = source;
    }

    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        if (context.get((Object)this) == null) {
            SolrRequestInfo requestInfo = SolrRequestInfo.getRequestInfo();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "testfunc: unweighted value source detected.  delegate=" + this.source + " request=" + (requestInfo == null ? "null" : requestInfo.getReq()));
        }
        return this.source.getValues(context, readerContext);
    }

    public boolean equals(Object o) {
        return o instanceof TestValueSource && this.source.equals((Object)((TestValueSource)((Object)o)).source);
    }

    public int hashCode() {
        return this.source.hashCode() + TestValueSource.class.hashCode();
    }

    public String description() {
        return "testfunc(" + this.source.description() + ')';
    }

    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        context.put(this, this);
    }

    public SortField getSortField(boolean reverse) {
        return super.getSortField(reverse);
    }
}

