/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Context;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class AquilaProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN_A = new PatternBuilder().text("$$").expression("[^,]*,").number("(d+),").number("(d+),").number("(-?d+.d+),").number("(-?d+.d+),").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").expression("([AV]),").groupBegin().number("(d+),").number("(d+),").number("(d+),").groupBegin().number("d+,").number("(d+),").number("([01]),").number("[01],").number("[01],").number("[01],").number("(?:d+,){3}").number("([01]),").number("([01]),").number("d+,").number("([01]),").number("[01],").number("(?:d+,){7}").number("[01],").number("(?:d+,){8}").number("([01]),").number("([01]),").number("([01]),").number("([01]),").or().number("(d+),").number("(?:d+,){3}").number("[01],").number("[01],").number("(?:d+,){3}").number("([01]),").number("(?:d+,){2}").number("[01],").number("([01]),").number("[01],").number("(?:d+,){5}").number("[01],").number("[01],").number("(?:d+,){6}").number("[01],").number("[01],").number("[01],[01],[01],[01],").number("(d+),").number("(d+),").number("(?:d+,){6}").expression("P([^,]+),").expression("D([^,]+),").number("-?d+,").number("-?d+,").number("-?d+,").number("d+,").or().number("(d+),").number("(d+),").number("(d+.d+),").number("(?:d+,){2}").number("(d+),").number("([01]),").number("[01],").number("[01],").number("[01],").number("(?:[01],){2}").number("[01],").number("([01]),").number("([01]),").number("(?:[01],){2}").number("([01]),").number("(?:[01],){6}").number("[01],").number("[01],").number("(?:[01],){4}").number("[01],").number("[01],").number("[01],").number("[01],").number("(?:[01],){4}").number("(d+),").number("(d+),").groupEnd().or().number("(d+),").expression("([^,]+),").groupEnd().text("*").number("xx").compile();
    private static final Pattern PATTERN_B_1 = new PatternBuilder().text("$").expression("[^,]+,").expression("[^,]+,").expression("[^,]+,").expression(".{2},").number("d+,").expression("[LH],").number("(d+),").expression("[^,]+,").number("([01]),").number("(dd)(dd)(dddd),").number("(dd)(dd)(dd),").number("(-?d+.d+),").expression("([NS]),").number("(-?d+.d+),").expression("([EW]),").number("(d+.d+),").number("(d+),").number("(d+),").number("(-?d+.d+),").number("(d+.d+),").number("(d+.d+),").expression("[^,]+,").number("([01]),").number("([01]),").number("(d+.d+),").number("(d+.d+),").number("([01]),").expression("[CO],").number("(d+),").number("(d+),").number("(d+),").number("(x+),").number("(x+),").number("(d+),(x+),(x+),").number("(d+),(x+),(x+),").number("(d+),(x+),(x+),").number("(d+),(x+),(x+),").number("([01])+,").number("([01])+,").number("d+,").number("(d+.d+),").number("(d+.d+),").number("d+,").any().compile();
    private static final Pattern PATTERN_B_2 = new PatternBuilder().text("$").expression("[^,]+,").expression("[^,]+,").expression("(.{3}),").number("(d+),").expression(".{2},").number("(dd)(dd)(dddd)").number("(dd)(dd)(dd),").expression("([AV]),").number("(-?d+.d+),").expression("([NS]),").number("(-?d+.d+),").expression("([EW]),").number("(-?d+.d+),").number("(d+.d+),").any().compile();

    public AquilaProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Position decodeA(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_A, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("event", parser.nextInt(0));
        position.setLatitude(parser.nextDouble(0.0));
        position.setLongitude(parser.nextDouble(0.0));
        position.setTime(parser.nextDateTime());
        position.setValid(parser.next().equals("A"));
        if (parser.hasNext(3)) {
            position.set("rssi", parser.nextInt(0));
            position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble(0.0)));
            position.set("odometer", parser.nextInt(0));
        }
        if (parser.hasNext(9)) {
            position.set("fuel", parser.nextInt());
            position.set("in1", parser.next());
            position.set("charge", parser.next().equals("1"));
            position.set("in2", parser.next());
            position.set("ignition", parser.nextInt(0) == 1);
            int course = (parser.nextInt(0) << 3) + (parser.nextInt(0) << 2) + (parser.nextInt(0) << 1) + parser.nextInt(0);
            if (course > 0 && course <= 8) {
                position.setCourse((course - 1) * 45);
            }
        } else if (parser.hasNext(7)) {
            position.setCourse(parser.nextInt(0));
            position.set("charge", parser.next().equals("1"));
            position.set("ignition", parser.nextInt(0) == 1);
            position.set("power", parser.nextInt(0));
            position.set("battery", parser.nextInt(0));
            String obd = parser.next();
            position.set("obd", obd.substring(1, obd.length() - 1));
            String dtcs = parser.next();
            position.set("dtcs", dtcs.substring(1, dtcs.length() - 1).replace('|', ' '));
        } else if (parser.hasNext(10)) {
            position.setCourse(parser.nextInt(0));
            position.set("sat", parser.nextInt(0));
            position.set("hdop", parser.nextDouble(0.0));
            position.set("adc1", parser.nextInt(0));
            position.set("in1", parser.nextInt(0));
            position.set("charge", parser.next().equals("1"));
            position.set("in2", parser.nextInt(0));
            position.set("ignition", parser.nextInt(0) == 1);
            position.set("power", parser.nextInt(0));
            position.set("battery", parser.nextInt(0));
        } else if (parser.hasNext(2)) {
            position.set("sensorId", parser.nextInt());
            position.set("sensorData", parser.next());
        }
        return position;
    }

    private Position decodeB2(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_B_2, sentence);
        if (!parser.matches()) {
            return null;
        }
        String type = parser.next();
        String id = parser.next();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        position.setAltitude(parser.nextDouble());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
        if (type.equals("EMR") && channel != null) {
            String password = Context.getIdentityManager().lookupAttributeString(deviceSession.getDeviceId(), this.getProtocolName() + ".password", "aquila123", true);
            channel.writeAndFlush((Object)new NetworkMessage("#set$" + id + "@" + password + "#EMR_MODE:0*", remoteAddress));
        }
        return position;
    }

    private Position decodeB1(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_B_1, sentence);
        if (!parser.matches()) {
            return null;
        }
        String id = parser.next();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setValid(parser.nextInt() == 1);
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
        position.setCourse(parser.nextInt().intValue());
        position.set("sat", parser.nextInt());
        position.setAltitude(parser.nextDouble());
        position.set("pdop", parser.nextDouble());
        position.set("hdop", parser.nextDouble());
        position.set("ignition", parser.nextInt() == 1);
        position.set("charge", parser.nextInt() == 1);
        position.set("power", parser.nextDouble());
        position.set("battery", parser.nextDouble());
        if (parser.nextInt() == 1) {
            position.set("alarm", "sos");
        }
        Network network = new Network();
        int rssi = parser.nextInt();
        int mcc = parser.nextInt();
        int mnc = parser.nextInt();
        network.addCellTower(CellTower.from(mcc, mnc, parser.nextHexInt(), parser.nextHexInt().intValue(), rssi));
        for (int i = 0; i < 4; ++i) {
            rssi = parser.nextInt();
            network.addCellTower(CellTower.from(mcc, mnc, parser.nextHexInt(), parser.nextHexInt().intValue(), rssi));
        }
        position.setNetwork(network);
        position.set("input", parser.nextBinInt());
        position.set("output", parser.nextBinInt());
        position.set("adc1", parser.nextDouble());
        position.set("adc2", parser.nextDouble());
        return position;
    }

    private Position decodeB(Channel channel, SocketAddress remoteAddress, String sentence) {
        if (sentence.contains("EMR") || sentence.contains("SEM")) {
            return this.decodeB2(channel, remoteAddress, sentence);
        }
        return this.decodeB1(channel, remoteAddress, sentence);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        if (sentence.startsWith("$$")) {
            return this.decodeA(channel, remoteAddress, sentence);
        }
        return this.decodeB(channel, remoteAddress, sentence);
    }
}

