/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.DateTimeFormatterProvider;
import net.arnx.jsonic.JSON;

final class MonthConverter
implements Converter {
    @Override
    public boolean accept(Class<?> cls) {
        return Month.class == cls;
    }

    @Override
    public Object convert(JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            value = ((Map)value).get(null);
        } else if (value instanceof List) {
            List src = (List)value;
            Object object = value = !src.isEmpty() ? (Object)src.get(0) : null;
        }
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return Month.of(((Number)value).intValue());
        }
        if (value instanceof String) {
            String text = (String)value;
            String format = context.getDateFormatText();
            if (format != null) {
                return context.getLocalCache().get(DateTimeFormatter.class, format, DateTimeFormatterProvider.INSTANCE).parse((CharSequence)text, new TemporalQuery<Month>(){

                    @Override
                    public Month queryFrom(TemporalAccessor temporal) {
                        return Month.from(temporal);
                    }
                });
            }
            if (text.length() > 0 && text.charAt(0) >= '0' && text.charAt(0) <= '9') {
                return Month.of(Integer.parseInt(text));
            }
            return Month.valueOf(text);
        }
        throw new UnsupportedOperationException("Cannot convert " + value.getClass() + " to " + t);
    }
}

