/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.util;

import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import net.arnx.jsonic.util.ClassUtil;
import net.arnx.jsonic.util.ExtendedDateFormat;

public class LocalCache {
    private static final int CACHE_SIZE = 256;
    private ResourceBundle resources;
    private Locale locale;
    private TimeZone timeZone;
    private StringBuilder builderCache;
    private int stringCacheCount = 0;
    private String[] stringCache;
    private Map<Class<?>, Map<Object, Object>> formatCache;

    public LocalCache(String bundle, Locale locale, TimeZone timeZone) {
        this.resources = ResourceBundle.getBundle(bundle, locale);
        this.locale = locale;
        this.timeZone = timeZone;
    }

    public StringBuilder getCachedBuffer() {
        if (this.builderCache == null) {
            this.builderCache = new StringBuilder();
        } else {
            this.builderCache.setLength(0);
        }
        return this.builderCache;
    }

    public String getString(CharSequence cs) {
        if (cs.length() == 0) {
            return "";
        }
        if (cs.length() < 32 && this.stringCacheCount++ > 16) {
            String str;
            int index = this.getCacheIndex(cs);
            if (index < 0) {
                return cs.toString();
            }
            if (this.stringCache == null) {
                this.stringCache = new String[256];
            }
            if ((str = this.stringCache[index]) == null || str.length() != cs.length()) {
                this.stringCache[index] = str = cs.toString();
                return str;
            }
            for (int i = 0; i < cs.length(); ++i) {
                if (str.charAt(i) == cs.charAt(i)) continue;
                this.stringCache[index] = str = cs.toString();
                return str;
            }
            return str;
        }
        return cs.toString();
    }

    private int getCacheIndex(CharSequence cs) {
        int h = 0;
        int max = Math.min(16, cs.length());
        for (int i = 0; i < max; ++i) {
            h = h * 31 + cs.charAt(i);
        }
        return h & 0xFF;
    }

    public <T> T get(Class<T> cls, Object key, Provider<T> provider) {
        Object f;
        Map<Object, Object> map = null;
        if (this.formatCache == null) {
            this.formatCache = new HashMap();
        } else {
            map = this.formatCache.get(cls);
        }
        if (map == null) {
            map = new HashMap<Object, Object>();
            this.formatCache.put(cls, map);
        }
        if ((f = map.get(key)) == null) {
            f = provider.get(key, this.locale, this.timeZone);
            map.put(key, f);
        }
        return (T)f;
    }

    public NumberFormat getNumberFormat(String format) {
        return this.get(NumberFormat.class, format, NumberFormatProvider.INSTANCE);
    }

    public DateFormat getDateFormat(String format) {
        return this.get(DateFormat.class, format, DateFormatProvider.INSTANCE);
    }

    public Type getResolvedType(Type ptype, Class<?> pcls, Type type) {
        return this.get(Type.class, new ParameterTypeKey(ptype, pcls, type), ResolvedTypeProvider.INSTANCE);
    }

    public String getMessage(String id) {
        return this.getMessage(id, null);
    }

    public String getMessage(String id, Object ... args) {
        if (args != null && args.length > 0) {
            return MessageFormat.format(this.resources.getString(id), args);
        }
        return this.resources.getString(id);
    }

    private static class ResolvedTypeProvider
    implements Provider<Type> {
        public static final ResolvedTypeProvider INSTANCE = new ResolvedTypeProvider();

        private ResolvedTypeProvider() {
        }

        @Override
        public Type get(Object o, Locale locale, TimeZone timeZone) {
            ParameterTypeKey key = (ParameterTypeKey)o;
            return ClassUtil.getResolvedType(key.ptype, key.pcls, key.type);
        }
    }

    private static class DateFormatProvider
    implements Provider<DateFormat> {
        public static final DateFormatProvider INSTANCE = new DateFormatProvider();

        private DateFormatProvider() {
        }

        @Override
        public DateFormat get(Object format, Locale locale, TimeZone timeZone) {
            ExtendedDateFormat dformat = new ExtendedDateFormat((String)format, locale);
            dformat.setTimeZone(timeZone);
            return dformat;
        }
    }

    private static class NumberFormatProvider
    implements Provider<NumberFormat> {
        public static final NumberFormatProvider INSTANCE = new NumberFormatProvider();

        private NumberFormatProvider() {
        }

        @Override
        public NumberFormat get(Object format, Locale locale, TimeZone timeZone) {
            return new DecimalFormat((String)format, new DecimalFormatSymbols(locale));
        }
    }

    public static interface Provider<T> {
        public T get(Object var1, Locale var2, TimeZone var3);
    }

    private static class ParameterTypeKey {
        private Type ptype;
        private Class<?> pcls;
        private Type type;

        public ParameterTypeKey(Type ptype, Class<?> pcls, Type type) {
            this.ptype = ptype;
            this.pcls = pcls;
            this.type = type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.ptype == null ? 0 : this.ptype.hashCode());
            result = 31 * result + (this.pcls == null ? 0 : this.pcls.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParameterTypeKey other = (ParameterTypeKey)obj;
            if (this.ptype == null ? other.ptype != null : !this.ptype.equals(other.ptype)) {
                return false;
            }
            if (this.pcls == null ? other.pcls != null : !this.pcls.equals(other.pcls)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

