/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.core.xml.AbstractCamelFactoryBean;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.util.URISupport;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractCamelEndpointFactoryBean
extends AbstractCamelFactoryBean<Endpoint> {
    @XmlAttribute(required=false)
    @Deprecated
    private Boolean singleton;
    @XmlAttribute(required=true)
    private String uri;
    @XmlAttribute
    @Deprecated
    private ExchangePattern pattern;
    @XmlElementRef
    private List<PropertyDefinition> properties = new ArrayList<PropertyDefinition>();
    @XmlTransient
    private Endpoint endpoint;

    @Override
    public Endpoint getObject() throws Exception {
        if (this.endpoint == null || !this.endpoint.isSingleton()) {
            String resolved = this.getCamelContext().resolvePropertyPlaceholders(this.uri);
            String target = this.createUri(resolved);
            this.endpoint = this.getCamelContext().getEndpoint(target);
            if (this.endpoint == null) {
                throw new NoSuchEndpointException(target);
            }
        }
        return this.endpoint;
    }

    @Override
    public Class<Endpoint> getObjectType() {
        return Endpoint.class;
    }

    @Deprecated
    public Boolean getSingleton() {
        return this.singleton;
    }

    @Deprecated
    public void setSingleton(Boolean singleton) {
        this.singleton = singleton;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @Deprecated
    public ExchangePattern getPattern() {
        return this.pattern;
    }

    @Deprecated
    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    public List<PropertyDefinition> getProperties() {
        return this.properties;
    }

    public void setProperties(List<PropertyDefinition> properties) {
        this.properties = properties;
    }

    private String createUri(String uri) throws Exception {
        if (this.properties == null || this.properties.isEmpty()) {
            return uri;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (PropertyDefinition property : this.properties) {
            String value = this.getCamelContext().resolvePropertyPlaceholders(property.getValue());
            map.put(property.getKey(), value);
        }
        return URISupport.appendParametersToURI(uri, map);
    }
}

