/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.journal.howl;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.activeio.journal.InvalidRecordLocationException;
import org.apache.activeio.journal.Journal;
import org.apache.activeio.journal.JournalEventListener;
import org.apache.activeio.journal.RecordLocation;
import org.apache.activeio.journal.howl.LongRecordLocation;
import org.apache.activeio.packet.ByteArrayPacket;
import org.apache.activeio.packet.Packet;
import org.objectweb.howl.log.Configuration;
import org.objectweb.howl.log.InvalidFileSetException;
import org.objectweb.howl.log.InvalidLogBufferException;
import org.objectweb.howl.log.InvalidLogKeyException;
import org.objectweb.howl.log.LogConfigurationException;
import org.objectweb.howl.log.LogEventListener;
import org.objectweb.howl.log.LogRecord;
import org.objectweb.howl.log.Logger;

public class HowlJournal
implements Journal {
    private final Logger logger;
    private RecordLocation lastMark;

    public HowlJournal(Configuration configuration) throws InvalidFileSetException, LogConfigurationException, InvalidLogBufferException, ClassNotFoundException, IOException, InterruptedException {
        this.logger = new Logger(configuration);
        this.logger.open();
        this.lastMark = new LongRecordLocation(this.logger.getActiveMark());
    }

    public RecordLocation write(Packet packet, boolean sync) throws IOException {
        try {
            return new LongRecordLocation(this.logger.put(packet.sliceAsBytes(), sync));
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException("Journal write failed: " + e).initCause(e);
        }
    }

    public void setMark(RecordLocation recordLocator, boolean force) throws InvalidRecordLocationException, IOException {
        try {
            long location = this.toLong(recordLocator);
            this.logger.mark(location, force);
            this.lastMark = recordLocator;
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (InvalidLogKeyException e) {
            throw new InvalidRecordLocationException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw (IOException)new IOException("Journal write failed: " + e).initCause(e);
        }
    }

    private long toLong(RecordLocation recordLocator) throws InvalidRecordLocationException {
        if (recordLocator == null || recordLocator.getClass() != LongRecordLocation.class) {
            throw new InvalidRecordLocationException();
        }
        long location = ((LongRecordLocation)recordLocator).getLongLocation();
        return location;
    }

    public RecordLocation getMark() {
        return this.lastMark;
    }

    public void close() throws IOException {
        try {
            this.logger.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
        catch (Exception e) {
            throw (IOException)new IOException("Journal close failed: " + e).initCause(e);
        }
    }

    public void setJournalEventListener(final JournalEventListener eventListener) {
        this.logger.setLogEventListener(new LogEventListener(){

            public void logOverflowNotification(long key) {
                eventListener.overflowNotification(new LongRecordLocation(key));
            }
        });
    }

    public RecordLocation getNextRecordLocation(RecordLocation lastLocation) throws InvalidRecordLocationException {
        if (lastLocation == null) {
            if (this.lastMark != null) {
                lastLocation = this.lastMark;
            } else {
                return null;
            }
        }
        try {
            LogRecord next;
            do {
                LogRecord record;
                if ((next = this.logger.getNext(record = this.logger.get(null, this.toLong(lastLocation)))) == null || next.length == 0) {
                    return null;
                }
                lastLocation = new LongRecordLocation(next.key);
            } while (next.isCTRL());
            return lastLocation;
        }
        catch (Exception e) {
            throw (InvalidRecordLocationException)new InvalidRecordLocationException().initCause(e);
        }
    }

    public Packet read(RecordLocation location) throws InvalidRecordLocationException, IOException {
        try {
            LogRecord record = this.logger.get(null, this.toLong(location));
            return new ByteArrayPacket(record.data);
        }
        catch (InvalidLogKeyException e) {
            throw new InvalidRecordLocationException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw (IOException)new IOException("Journal write failed: " + e).initCause(e);
        }
    }
}

