/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.io;

import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;

public final class FileAttributes {
    public static final FileAttributes BROKEN_SYMLINK = new FileAttributes(null, 1, 0L, 0L);
    @Nullable
    public final Type type;
    public final byte flags;
    public final long length;
    public final long lastModified;

    public FileAttributes(boolean directory, boolean special, boolean symlink, boolean hidden, long length, long lastModified, boolean writable) {
        this(FileAttributes.type(directory, special), FileAttributes.flags(symlink, hidden, !writable), length, lastModified);
    }

    private FileAttributes(@Nullable Type type2, byte flags, long length, long lastModified) {
        this.type = type2;
        this.flags = flags;
        this.length = length;
        this.lastModified = lastModified;
    }

    private static Type type(boolean isDirectory, boolean isSpecial) {
        return isDirectory ? Type.DIRECTORY : (isSpecial ? Type.SPECIAL : Type.FILE);
    }

    private static byte flags(boolean isSymlink, boolean isHidden, boolean isReadOnly) {
        byte flags = 0;
        if (isSymlink) {
            flags = (byte)(flags | 1);
        }
        if (isHidden) {
            flags = (byte)(flags | 2);
        }
        if (isReadOnly) {
            flags = (byte)(flags | 4);
        }
        return flags;
    }

    public boolean isDirectory() {
        return this.type == Type.DIRECTORY;
    }

    public boolean isSymLink() {
        return BitUtil.isSet(this.flags, (byte)1);
    }

    public boolean isWritable() {
        return !BitUtil.isSet(this.flags, (byte)4);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileAttributes that = (FileAttributes)o;
        if (this.flags != that.flags) {
            return false;
        }
        if (this.lastModified != that.lastModified) {
            return false;
        }
        if (this.length != that.length) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result2 = this.type != null ? this.type.hashCode() : 0;
        result2 = 31 * result2 + this.flags;
        result2 = 31 * result2 + (int)(this.length ^ this.length >>> 32);
        result2 = 31 * result2 + (int)(this.lastModified ^ this.lastModified >>> 32);
        return result2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[type:");
        if (this.type == Type.FILE) {
            sb.append('f');
        } else if (this.type == Type.DIRECTORY) {
            sb.append('d');
        } else if (this.type == Type.SPECIAL) {
            sb.append('!');
        } else {
            sb.append('-');
        }
        if (BitUtil.isSet(this.flags, (byte)1)) {
            sb.append('l');
        }
        if (BitUtil.isSet(this.flags, (byte)2)) {
            sb.append('.');
        }
        if (BitUtil.isSet(this.flags, (byte)4)) {
            sb.append(" ro");
        }
        sb.append(" length:").append(this.length);
        sb.append(" modified:").append(this.lastModified);
        sb.append(']');
        return sb.toString();
    }

    public static enum Type {
        FILE,
        DIRECTORY,
        SPECIAL;

    }
}

