/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.typeinference;

import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.visitors.typeinference.TypeUpdateEntry;
import jadx.core.dex.visitors.typeinference.TypeUpdateFlags;
import java.util.ArrayList;
import java.util.List;

public class TypeUpdateInfo {
    private final TypeUpdateFlags flags;
    private final List<TypeUpdateEntry> updates = new ArrayList<TypeUpdateEntry>();

    public TypeUpdateInfo(TypeUpdateFlags flags) {
        this.flags = flags;
    }

    public void requestUpdate(InsnArg arg, ArgType changeType) {
        this.updates.add(new TypeUpdateEntry(arg, changeType));
    }

    public boolean isProcessed(InsnArg arg) {
        if (this.updates.isEmpty()) {
            return false;
        }
        for (TypeUpdateEntry entry : this.updates) {
            if (entry.getArg() != arg) continue;
            return true;
        }
        return false;
    }

    public void rollbackUpdate(InsnArg arg) {
        this.updates.removeIf(updateEntry -> updateEntry.getArg() == arg);
    }

    public List<TypeUpdateEntry> getUpdates() {
        return this.updates;
    }

    public TypeUpdateFlags getFlags() {
        return this.flags;
    }
}

