/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import com.beust.jcommander.Parameter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.jf.dexlib2.analysis.ClassPath;
import org.jf.dexlib2.analysis.ClassPathResolver;
import org.jf.dexlib2.dexbacked.OatFile;
import org.jf.dexlib2.iface.DexFile;
import org.jf.util.jcommander.ColonParameterSplitter;
import org.jf.util.jcommander.ExtendedParameter;

public class AnalysisArguments {
    @Parameter(names={"-b", "--bootclasspath", "--bcp"}, description="A colon separated list of the files to include in the bootclasspath when analyzing the dex file. If not specified, baksmali will attempt to choose an appropriate default. When analyzing oat files, this can simply be the path to the device's boot.oat file. A single empty string can be used to specify that an empty bootclasspath should be used. (e.g. --bootclasspath \"\") See baksmali help classpath for more information.", splitter=ColonParameterSplitter.class)
    @ExtendedParameter(argumentNames={"classpath"})
    public List<String> bootClassPath = null;
    @Parameter(names={"-c", "--classpath", "--cp"}, description="A colon separated list of additional files to include in the classpath when analyzing the dex file. These will be added to the classpath after any bootclasspath entries.", splitter=ColonParameterSplitter.class)
    @ExtendedParameter(argumentNames={"classpath"})
    public List<String> classPath = Lists.newArrayList();
    @Parameter(names={"-d", "--classpath-dir", "--cpd", "--dir"}, description="A directory to search for classpath files. This option can be used multiple times to specify multiple directories to search. They will be searched in the order they are provided.")
    @ExtendedParameter(argumentNames={"dir"})
    public List<String> classPathDirectories = null;

    @Nonnull
    public ClassPath loadClassPathForDexFile(@Nonnull File dexFileDir, @Nonnull DexFile dexFile, boolean checkPackagePrivateAccess) throws IOException {
        return this.loadClassPathForDexFile(dexFileDir, dexFile, checkPackagePrivateAccess, -1);
    }

    @Nonnull
    public ClassPath loadClassPathForDexFile(@Nonnull File dexFileDir, @Nonnull DexFile dexFile, boolean checkPackagePrivateAccess, int oatVersion) throws IOException {
        if (oatVersion == -1) {
            if (dexFile instanceof OatFile.OatDexFile) {
                checkPackagePrivateAccess = true;
                oatVersion = ((OatFile.OatDexFile)dexFile).getContainer().getOatVersion();
            }
        } else {
            checkPackagePrivateAccess = true;
        }
        if (this.classPathDirectories == null || this.classPathDirectories.size() == 0) {
            this.classPathDirectories = Lists.newArrayList((Object[])new String[]{dexFileDir.getPath()});
        }
        ArrayList filteredClassPathDirectories = Lists.newArrayList();
        if (this.classPathDirectories != null) {
            for (String dir : this.classPathDirectories) {
                File file = new File(dir);
                if (!file.exists()) {
                    System.err.println(String.format("Warning: directory %s does not exist. Ignoring.", dir));
                    continue;
                }
                if (!file.isDirectory()) {
                    System.err.println(String.format("Warning: %s is not a directory. Ignoring.", dir));
                    continue;
                }
                filteredClassPathDirectories.add(dir);
            }
        }
        ClassPathResolver resolver = this.bootClassPath == null ? new ClassPathResolver((List)filteredClassPathDirectories, this.classPath, dexFile) : (this.bootClassPath.size() == 1 && this.bootClassPath.get(0).length() == 0 ? new ClassPathResolver((List)ImmutableList.of(), (List)ImmutableList.of(), this.classPath, dexFile) : new ClassPathResolver((List)filteredClassPathDirectories, this.bootClassPath, this.classPath, dexFile));
        if (oatVersion == 0 && dexFile instanceof OatFile.OatDexFile) {
            oatVersion = ((OatFile.OatDexFile)dexFile).getContainer().getOatVersion();
        }
        return new ClassPath((Iterable)resolver.getResolvedClassProviders(), checkPackagePrivateAccess, oatVersion);
    }

    public static class CheckPackagePrivateArgument {
        @Parameter(names={"--check-package-private-access", "--package-private", "--checkpp", "--pp"}, description="Use the package-private access check when calculating vtable indexes. This is enabled by default for oat files. For odex files, this is only needed for odexes from 4.2.0. It was reverted in 4.2.1.")
        public boolean checkPackagePrivateAccess = false;
    }
}

