/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.jd.core.v1.ClassFileToJavaSourceDecompiler;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.util.decompiler.ClassPathLoader;
import org.jd.gui.util.decompiler.ContainerLoader;
import org.jd.gui.util.decompiler.LineNumberStringBuilderPrinter;
import org.jd.gui.util.decompiler.NopPrinter;
import org.jd.gui.util.decompiler.StringBuilderPrinter;
import org.jd.gui.util.exception.ExceptionUtil;
import org.jd.gui.util.io.NewlineOutputStream;
import org.jd.gui.view.component.TypePage;

public class ClassFilePage
extends TypePage {
    protected static final String ESCAPE_UNICODE_CHARACTERS = "ClassFileDecompilerPreferences.escapeUnicodeCharacters";
    protected static final String REALIGN_LINE_NUMBERS = "ClassFileDecompilerPreferences.realignLineNumbers";
    protected static final String WRITE_LINE_NUMBERS = "ClassFileSaverPreferences.writeLineNumbers";
    protected static final String WRITE_METADATA = "ClassFileSaverPreferences.writeMetadata";
    protected static final String JD_CORE_VERSION = "JdGuiPreferences.jdCoreVersion";
    protected static final ClassFileToJavaSourceDecompiler DECOMPILER;
    protected int maximumLineNumber = -1;

    public ClassFilePage(API api, Container.Entry entry) {
        super(api, entry);
        Map<String, String> preferences = api.getPreferences();
        this.setErrorForeground(Color.decode(preferences.get("JdGuiPreferences.errorBackgroundColor")));
        this.decompile(preferences);
    }

    public void decompile(Map<String, String> preferences) {
        try {
            this.clearHyperlinks();
            this.clearLineNumbers();
            this.declarations.clear();
            this.typeDeclarations.clear();
            this.strings.clear();
            boolean realignmentLineNumbers = ClassFilePage.getPreferenceValue(preferences, REALIGN_LINE_NUMBERS, true);
            boolean unicodeEscape = ClassFilePage.getPreferenceValue(preferences, ESCAPE_UNICODE_CHARACTERS, false);
            HashMap<String, Object> configuration = new HashMap<String, Object>();
            configuration.put("realignLineNumbers", realignmentLineNumbers);
            this.setShowMisalignment(realignmentLineNumbers);
            ContainerLoader loader = new ContainerLoader(this.entry);
            ClassFilePrinter printer = new ClassFilePrinter();
            printer.setRealignmentLineNumber(realignmentLineNumbers);
            printer.setUnicodeEscape(unicodeEscape);
            String entryPath = this.entry.getPath();
            assert (entryPath.endsWith(".class"));
            String entryInternalName = entryPath.substring(0, entryPath.length() - 6);
            DECOMPILER.decompile(loader, printer, entryInternalName, configuration);
        }
        catch (Throwable t) {
            assert (ExceptionUtil.printStackTrace(t));
            this.setText("// INTERNAL ERROR //");
        }
        this.maximumLineNumber = this.getMaximumSourceLineNumber();
    }

    protected static boolean getPreferenceValue(Map<String, String> preferences, String key, boolean defaultValue) {
        String v = preferences.get(key);
        return v == null ? defaultValue : Boolean.valueOf(v);
    }

    @Override
    public String getSyntaxStyle() {
        return "text/java";
    }

    @Override
    public String getFileName() {
        String path = this.entry.getPath();
        int index = path.lastIndexOf(46);
        return path.substring(0, index) + ".java";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void save(API api, OutputStream os) {
        try {
            Map<String, String> preferences = api.getPreferences();
            boolean realignmentLineNumbers = ClassFilePage.getPreferenceValue(preferences, REALIGN_LINE_NUMBERS, true);
            boolean unicodeEscape = ClassFilePage.getPreferenceValue(preferences, ESCAPE_UNICODE_CHARACTERS, false);
            boolean showLineNumbers = ClassFilePage.getPreferenceValue(preferences, WRITE_LINE_NUMBERS, true);
            HashMap<String, Object> configuration = new HashMap<String, Object>();
            configuration.put("realignLineNumbers", realignmentLineNumbers);
            ContainerLoader loader = new ContainerLoader(this.entry);
            LineNumberStringBuilderPrinter printer = new LineNumberStringBuilderPrinter();
            printer.setRealignmentLineNumber(realignmentLineNumbers);
            printer.setUnicodeEscape(unicodeEscape);
            printer.setShowLineNumbers(showLineNumbers);
            String entryPath = this.entry.getPath();
            assert (entryPath.endsWith(".class"));
            String entryInternalName = entryPath.substring(0, entryPath.length() - 6);
            DECOMPILER.decompile(loader, printer, entryInternalName, configuration);
            StringBuilder stringBuffer = printer.getStringBuffer();
            if (ClassFilePage.getPreferenceValue(preferences, WRITE_METADATA, true)) {
                String location = new File(this.entry.getUri()).getPath().replaceAll("(^|[^\\\\])\\\\u", "\\\\\\\\u");
                stringBuffer.append("\n\n/* Location:              ");
                stringBuffer.append(location);
                int majorVersion = printer.getMajorVersion();
                if (majorVersion >= 45) {
                    stringBuffer.append("\n * Java compiler version: ");
                    if (majorVersion >= 49) {
                        stringBuffer.append(majorVersion - 44);
                    } else {
                        stringBuffer.append(majorVersion - 44);
                    }
                    stringBuffer.append(" (");
                    stringBuffer.append(majorVersion);
                    stringBuffer.append('.');
                    stringBuffer.append(printer.getMinorVersion());
                    stringBuffer.append(')');
                }
                stringBuffer.append("\n * JD-Core Version:       ");
                stringBuffer.append(preferences.get(JD_CORE_VERSION));
                stringBuffer.append("\n */");
            }
            try (PrintStream ps = new PrintStream((OutputStream)new NewlineOutputStream(os), true, "UTF-8");){
                ps.print(stringBuffer.toString());
                return;
            }
            catch (IOException e) {
                if ($assertionsDisabled) return;
                if (ExceptionUtil.printStackTrace(e)) return;
                throw new AssertionError();
            }
        }
        finally {
            Throwable t;
            assert (ExceptionUtil.printStackTrace(t));
            try (OutputStreamWriter writer = new OutputStreamWriter(os, Charset.defaultCharset());){
                writer.write("// INTERNAL ERROR //");
                return;
            }
            catch (IOException ee) {
                if ($assertionsDisabled) return;
                if (ExceptionUtil.printStackTrace(ee)) return;
                throw new AssertionError();
            }
        }
    }

    @Override
    public int getMaximumLineNumber() {
        return this.maximumLineNumber;
    }

    @Override
    public void goToLineNumber(int lineNumber) {
        block3: {
            int textAreaLineNumber = this.getTextAreaLineNumber(lineNumber);
            if (textAreaLineNumber > 0) {
                try {
                    int start = this.textArea.getLineStartOffset(textAreaLineNumber - 1);
                    int end = this.textArea.getLineEndOffset(textAreaLineNumber - 1);
                    this.setCaretPositionAndCenter(new DocumentRange(start, end));
                }
                catch (BadLocationException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block3;
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public boolean checkLineNumber(int lineNumber) {
        return lineNumber <= this.maximumLineNumber;
    }

    @Override
    public void preferencesChanged(Map<String, String> preferences) {
        DefaultCaret caret = (DefaultCaret)this.textArea.getCaret();
        int updatePolicy = caret.getUpdatePolicy();
        caret.setUpdatePolicy(1);
        this.decompile(preferences);
        caret.setUpdatePolicy(updatePolicy);
        super.preferencesChanged(preferences);
    }

    static {
        block2: {
            DECOMPILER = new ClassFileToJavaSourceDecompiler();
            try {
                String internalTypeName = ClassFilePage.class.getName().replace('.', '/');
                DECOMPILER.decompile(new ClassPathLoader(), new NopPrinter(), internalTypeName);
            }
            catch (Throwable t) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(t)) break block2;
                throw new AssertionError();
            }
        }
    }

    public class ClassFilePrinter
    extends StringBuilderPrinter {
        protected HashMap<String, TypePage.ReferenceData> referencesCache = new HashMap();
        int textAreaLineNumber = 1;

        @Override
        public void start(int maxLineNumber, int majorVersion, int minorVersion) {
            super.start(maxLineNumber, majorVersion, minorVersion);
            if (maxLineNumber == 0) {
                ClassFilePage.this.scrollPane.setLineNumbersEnabled(false);
            } else {
                ClassFilePage.this.setMaxLineNumber(maxLineNumber);
            }
        }

        @Override
        public void end() {
            ClassFilePage.this.setText(this.stringBuffer.toString());
        }

        @Override
        public void printStringConstant(String constant, String ownerInternalName) {
            if (constant == null) {
                constant = "null";
            }
            if (ownerInternalName == null) {
                ownerInternalName = "null";
            }
            ClassFilePage.this.strings.add(new TypePage.StringData(this.stringBuffer.length(), constant.length(), constant, ownerInternalName));
            super.printStringConstant(constant, ownerInternalName);
        }

        @Override
        public void printDeclaration(int type, String internalTypeName, String name, String descriptor) {
            if (internalTypeName == null) {
                internalTypeName = "null";
            }
            if (name == null) {
                name = "null";
            }
            if (descriptor == null) {
                descriptor = "null";
            }
            switch (type) {
                case 1: {
                    TypePage.DeclarationData data = new TypePage.DeclarationData(this.stringBuffer.length(), name.length(), internalTypeName, null, null);
                    ClassFilePage.this.declarations.put(internalTypeName, data);
                    ClassFilePage.this.typeDeclarations.put(this.stringBuffer.length(), data);
                    break;
                }
                case 4: {
                    ClassFilePage.this.declarations.put(internalTypeName + "-<init>-" + descriptor, new TypePage.DeclarationData(this.stringBuffer.length(), name.length(), internalTypeName, "<init>", descriptor));
                    break;
                }
                default: {
                    ClassFilePage.this.declarations.put(internalTypeName + '-' + name + '-' + descriptor, new TypePage.DeclarationData(this.stringBuffer.length(), name.length(), internalTypeName, name, descriptor));
                }
            }
            super.printDeclaration(type, internalTypeName, name, descriptor);
        }

        @Override
        public void printReference(int type, String internalTypeName, String name, String descriptor, String ownerInternalName) {
            if (internalTypeName == null) {
                internalTypeName = "null";
            }
            if (name == null) {
                name = "null";
            }
            if (descriptor == null) {
                descriptor = "null";
            }
            switch (type) {
                case 1: {
                    ClassFilePage.this.addHyperlink(new TypePage.HyperlinkReferenceData(this.stringBuffer.length(), name.length(), this.newReferenceData(internalTypeName, null, null, ownerInternalName)));
                    break;
                }
                case 4: {
                    ClassFilePage.this.addHyperlink(new TypePage.HyperlinkReferenceData(this.stringBuffer.length(), name.length(), this.newReferenceData(internalTypeName, "<init>", descriptor, ownerInternalName)));
                    break;
                }
                default: {
                    ClassFilePage.this.addHyperlink(new TypePage.HyperlinkReferenceData(this.stringBuffer.length(), name.length(), this.newReferenceData(internalTypeName, name, descriptor, ownerInternalName)));
                }
            }
            super.printReference(type, internalTypeName, name, descriptor, ownerInternalName);
        }

        @Override
        public void startLine(int lineNumber) {
            super.startLine(lineNumber);
            ClassFilePage.this.setLineNumber(this.textAreaLineNumber, lineNumber);
        }

        @Override
        public void endLine() {
            super.endLine();
            ++this.textAreaLineNumber;
        }

        @Override
        public void extraLine(int count) {
            super.extraLine(count);
            if (this.realignmentLineNumber) {
                this.textAreaLineNumber += count;
            }
        }

        public TypePage.ReferenceData newReferenceData(String internalName, String name, String descriptor, String scopeInternalName) {
            String key = internalName + '-' + name + '-' + descriptor + '-' + scopeInternalName;
            TypePage.ReferenceData reference = this.referencesCache.get(key);
            if (reference == null) {
                reference = new TypePage.ReferenceData(internalName, name, descriptor, scopeInternalName);
                this.referencesCache.put(key, reference);
                ClassFilePage.this.references.add(reference);
            }
            return reference;
        }
    }
}

