/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.preference;

import java.io.File;
import java.io.FileInputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public class ConfigurationFile {
    private static final String[] OPENPROJ_CONF_DIRS = new String[]{".projectlibre", "ProjectLibre"};
    private static File confFile;
    private static final String OPENPROJ_CONF_FILE = "projectlibre.conf";
    private static Properties confProps;
    private static Locale locale;
    private static final String OPENPROJ_RUN_CONF_FILE = "run.conf";
    private static Properties runProps;

    public static File getConfDir() {
        String string;
        if (confFile == null && (string = System.getProperty("user.home")) != null) {
            for (int i = 0; i < OPENPROJ_CONF_DIRS.length; ++i) {
                File file = new File(string + File.separator + OPENPROJ_CONF_DIRS[i]);
                if (!file.isDirectory()) continue;
                System.out.println("Conf file " + file.getPath() + " found");
                confFile = file;
                return file;
            }
        }
        return confFile;
    }

    public static String getProperty(String string) {
        if (confProps == null) {
            File file = ConfigurationFile.getConfDir();
            if (file == null) {
                return null;
            }
            File file2 = new File(file, OPENPROJ_CONF_FILE);
            if (!file2.exists()) {
                return null;
            }
            confProps = new Properties();
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                confProps.load(fileInputStream);
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return confProps.getProperty(string);
    }

    public static Locale getLocale() {
        if (locale == null) {
            String string = ConfigurationFile.getProperty("locale");
            if (string == null) {
                locale = Locale.getDefault();
            } else {
                String string2 = null;
                String string3 = null;
                String string4 = null;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "_-");
                if (!stringTokenizer.hasMoreTokens()) {
                    locale = Locale.getDefault();
                } else {
                    string2 = stringTokenizer.nextToken();
                    if (!stringTokenizer.hasMoreTokens()) {
                        locale = new Locale(string2);
                    } else {
                        string3 = stringTokenizer.nextToken();
                        if (!stringTokenizer.hasMoreTokens()) {
                            locale = new Locale(string2, string3);
                        } else {
                            string4 = stringTokenizer.nextToken();
                            locale = new Locale(string2, string3, string4);
                        }
                    }
                }
            }
        }
        return locale;
    }

    public static String getRunProperty(String string) {
        if (runProps == null) {
            File file = ConfigurationFile.getConfDir();
            if (file == null) {
                return null;
            }
            File file2 = new File(file, OPENPROJ_RUN_CONF_FILE);
            if (!file2.exists()) {
                return null;
            }
            runProps = new Properties();
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                runProps.load(fileInputStream);
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return runProps.getProperty(string);
    }

    static {
        locale = null;
    }
}

