/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2004 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef _PIINFO_H
#define _PIINFO_H

#include <vector>
#include <memory>
#include <map>
using namespace std;

#include <qstring.h>

class QHaccResultSet;

enum TargetType { NONE, DATABASE, SINGLEFILE, DIRECTORY, ANY };

class PluginInfo {
 public:
	PluginInfo();
	PluginInfo( const PluginInfo& );
	PluginInfo& operator=( const PluginInfo& );
	virtual ~PluginInfo();

	virtual QString descr() const;
	virtual QString stub() const;
	virtual QString fname() const;
	virtual TargetType target() const;
	virtual bool atomizer() const;
	virtual bool rawloader() const;
	virtual bool isGUISelectable() const;
	virtual auto_ptr<QHaccResultSet> prefs() const;

	void setFilename( const QString& fn );

 protected:
	QString description, stubby, filename;
	auto_ptr<QHaccResultSet> piprefs;
	TargetType targ;
	bool atom, raw, guisel;

 private:
	void reinit( const PluginInfo& );
};

#endif
