/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.file;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;

public interface ConfigurationSource {
    default public Resource getServerXml() throws IOException {
        return this.getConfResource("server.xml");
    }

    default public Resource getSharedWebXml() throws IOException {
        return this.getConfResource("web.xml");
    }

    default public Resource getConfResource(String name) throws IOException {
        String fullName = "conf/" + name;
        return this.getResource(fullName);
    }

    public Resource getResource(String var1) throws IOException;

    public URI getURI(String var1);

    public static class Resource
    implements AutoCloseable {
        private final InputStream inputStream;
        private final URI uri;

        public Resource(InputStream inputStream, URI uri) {
            this.inputStream = inputStream;
            this.uri = uri;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public URI getURI() {
            return this.uri;
        }

        public long getLastModified() throws MalformedURLException, IOException {
            return this.uri.toURL().openConnection().getLastModified();
        }

        @Override
        public void close() throws IOException {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
    }
}

