/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class LaipacProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("$AVRMC,").expression("([^,]+),").number("(dd)(dd)(dd),").expression("([AVRPavrp]),").number("(dd)(dd.d+),").expression("([NS]),").number("(ddd)(dd.d+),").number("([EW]),").number("(d+.d+),").number("(d+.d+),").number("(dd)(dd)(dd),").expression("([abZXTSMHFE86430]),").expression("([\\d.]+),").number("(d+),").number("(d),").number("(d+),").number("(d+)").number(",(xxxx)").number("(xxxx),").number("(ddd)").number("(ddd)").optional(4).text("*").number("(xx)").compile();

    public LaipacProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(String event) {
        switch (event) {
            case "Z": {
                return "lowBattery";
            }
            case "X": {
                return "geofenceEnter";
            }
            case "T": {
                return "tampering";
            }
            case "H": {
                return "powerOff";
            }
            case "8": {
                return "shock";
            }
            case "7": 
            case "4": {
                return "geofenceExit";
            }
            case "6": {
                return "overspeed";
            }
            case "3": {
                return "sos";
            }
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        if (sentence.startsWith("$ECHK") && channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage(sentence + "\r\n", remoteAddress));
            return null;
        }
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        String status = parser.next();
        String upperCaseStatus = status.toUpperCase();
        position.setValid(upperCaseStatus.equals("A") || upperCaseStatus.equals("R") || upperCaseStatus.equals("P"));
        position.set("status", status);
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        dateBuilder.setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        position.setTime(dateBuilder.getDate());
        String event = parser.next();
        position.set("alarm", this.decodeAlarm(event));
        position.set("event", event);
        position.set("battery", Double.parseDouble(parser.next().replaceAll("\\.", "")) * 0.001);
        position.set("odometer", parser.nextDouble());
        position.set("gps", parser.nextInt());
        position.set("adc1", parser.nextDouble() * 0.001);
        position.set("adc2", parser.nextDouble() * 0.001);
        Integer lac = parser.nextHexInt();
        Integer cid = parser.nextHexInt();
        Integer mcc = parser.nextInt();
        Integer mnc = parser.nextInt();
        if (lac != null && cid != null && mcc != null && mnc != null) {
            position.setNetwork(new Network(CellTower.from(mcc, mnc, lac, cid.intValue())));
        }
        String checksum = parser.next();
        if (channel != null) {
            if (event.equals("3")) {
                channel.writeAndFlush((Object)new NetworkMessage("$AVCFG,00000000,d*31\r\n", remoteAddress));
            } else if (event.equals("X") || event.equals("4")) {
                channel.writeAndFlush((Object)new NetworkMessage("$AVCFG,00000000,x*2D\r\n", remoteAddress));
            } else if (event.equals("Z")) {
                channel.writeAndFlush((Object)new NetworkMessage("$AVCFG,00000000,z*2F\r\n", remoteAddress));
            } else if (Character.isLowerCase(status.charAt(0))) {
                String response = "$EAVACK," + event + "," + checksum;
                response = response + Checksum.nmea(response) + "\r\n";
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
            }
        }
        return position;
    }
}

