/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import com.cloudhopper.commons.util.HexUtil;

public class ByteUtil {
    public static byte[] encodeBcd(String data, int num_bytes) {
        byte[] buf = new byte[num_bytes];
        if (data.length() % 2 != 0) {
            data = data + "F";
        }
        int index = 0;
        for (int i = 0; i < data.length(); i += 2) {
            StringBuilder x = new StringBuilder(data.substring(i, i + 2));
            x.reverse();
            buf[index] = ByteUtil.decodeHex(x.toString(), 2)[0];
            ++index;
        }
        return buf;
    }

    public static String decodeBcd(byte[] data, int offset, int len) {
        StringBuilder result = new StringBuilder();
        for (int i = offset; i < offset + len; ++i) {
            StringBuilder x = new StringBuilder(ByteUtil.encodeHex(data[i]));
            x.reverse();
            if (x.charAt(1) == 'F' || x.charAt(1) == 'f') {
                result.append(x.substring(0, 1));
                continue;
            }
            result.append(x.toString());
        }
        return result.toString();
    }

    @Deprecated
    public static byte[] decodeHex(String hexString, int width) {
        return HexUtil.toByteArray(hexString);
    }

    @Deprecated
    public static String encodeHex(byte value) {
        return HexUtil.toHexString(value);
    }

    @Deprecated
    public static String encodeHex(byte[] bytes) {
        return HexUtil.toHexString(bytes);
    }

    @Deprecated
    public static String encodeHex(byte[] data, char delimiter) {
        StringBuilder result = new StringBuilder();
        short val = 0;
        for (int i = 0; i < data.length; ++i) {
            val = ByteUtil.decodeUnsigned(data[i]);
            result.append(ByteUtil.padLeading(Integer.toHexString(val), 2));
            result.append(delimiter);
        }
        return result.toString();
    }

    public static String padLeading(String data, int width) {
        int num = width - data.length();
        if (0 >= num) {
            return data;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            result.append('0');
        }
        result.append(data);
        return result.toString();
    }

    public static short decodeUnsigned(byte signed) {
        if (signed >= 0) {
            return signed;
        }
        return (short)(256 + (short)signed);
    }
}

