# Amalgalite Changelog
## Version 1.6.1 - 2018-01-02

* Fix bug when using the `json` extension

## Version 1.6.0 - 2017-12-13

* Update to SQLite 3.21.0
* source id access methods
  * Amalgalite::SQLite3::Version.compiled_source_id
  * Amalgalite::SQLite3::Version.runtime_source_id
* enable new compile time options
  * SQLITE_ENABLE_DBPAGE_VTAB
  * SQLITE_ENABLE_MEMORY_MANAGEMENT
  * SQLITE_ENABLE_PREUPDATE_HOOK
  * SQLITE_ENABLE_SESSION
  * SQLITE_ENABLE_STMTVTAB

## Version 1.5.0 - 2015-12-06

* Update to SQLite 3.9.2
* Enable new SQLite features FTS5, JSON1

## Version 1.4.1 - 2015-09-13

* Update to SQLite 3.8.11.1
* Track down and cleanup sporadic rspec failures

## Version 1.4.0 - 2015-01-11

### Enhancements

* Update arrayfields dependency to 4.9.2
* Update to SQLite 3.8.7.4
* Make windows binary gems again, including ruby 2.1

## Version 1.3.0 - 2013-03-13

### Enhancements

* Update development dependencies to the latest levels
* Change up the development process to be inline with other projects
* Add Amalgalite::Database#import for mass execution of sql (bmalex 5a42f44f)
* Allow :memory: databases to Amalgalite::Requires (bmalex df9f70b8)
* Allow bootstrapping from an in-memory sql buffer (bmalex a17fb9cf)
* Make Amalgalite 1.9 -w clean
* Updates for Ruby 2.0

### Bug Fixes

* Fix handling of debug flags in extconf.rb (ged #22)
* Remove deprected Config:: (github issue #23)
* Correct detection of being loaded in conjunction with 'sqlite3' gem (github issue #15)
* Fix incorrect loading/reload of schema [GH #16]
* Fix setting of LOADED_FEATRES when requiring from a database (bmalex edb81837)
* Fix setting of require_path for files to require that are stored in the * database (bmalex de321b86)

## Version 1.1.2 - 2011-04-01

### Bug Fixes

* Remove example database that was mistakenly packaged with version 1.1.1

## Version 1.1.1 - 2011-03-27

### Enhancements

* Update to SQLite 3.7.5
* Enable SQLite Full Text Search compile time options FTS3 and FTS4 [github issue #10]
  http://www.sqlite.org/fts3.html
* Enable STAT2 SQLite compile time option to improve ANALYZE command support
  http://www.sqlite.org/lang_analyze.html

### Bug Fixes

* The C coded generated by gen_constants.rb was updated to support older
  compilers [github issue #8] (patch from josb)
* Fix 'amalgalite-pack --self' on ruby 1.9

## Version 1.0.0 - 2011-01-16

### Enhancements

* Update to 1.0.0
* Update to SQLite 3.7.4
* Update all runtime and development dependencies to the latest version

### Bug Fixes

* Fix FasterCSV/CSV compatibility issues with ruby 1.8/1.9 [github issue #4]
* Fix building issues for Ruby 1.9 [gitHub issue #5]
* Fix cross compilation problems when using rvm

## Version 0.15.0 - 2010-10-30

### Enhancements

* Update to sqlite 3.7.3
* Added Database#import_csv_to_table
* Added MemoryDatabase class

### Bug Fixes

* Unable to run specs from gem [GH Issue #3]

## Version 0.12.1 - 2010-02-17

### Enhancements

* Update to sqlite 3.6.22

## Version 0.12.0 - 2009-10-29

### Enhancements

* Update to sqlite 3.6.19

### Bug Fixes

* Improve detection of schema changes
* Add missing development dependencies 
* Ensure the initialization of the underlying sqlite3 library
* Fix a segmentation fault that happend in Sequel tests
* Fix tracking of highwater memory usage
* Fix testing interruptability of sqlite3 commands

## Version 0.11.0 - 2009-08-23

### Enhancements

* Update to SQLite 3.6.17

### Bug Fixes

* Add compiletime vs. runtime library checking.
* Fix missing datatypes to typemap (reported by Jay Godse) 

## Version 0.10.2 - 2009-08-10

### Bug Fixes

* Statement#execute was not expanding an Array passed in to the positional
  #bind parameters (reported by Steven Harris).

## Version 0.10.1 - 2009-08-01

### Enhancements

* Add version subdirectory for extension on all platforms for building locally
  on gem install.
* Add gem for x86-ming32 platform  
* Add specs to validate the R*Tree index is compiled correctly

### Bug Fixes

* Small documentation change for Amalgalite::Database#new

## Version 0.10.0 - 2009-06-28

### Enhancements 

* windows gem is now a fat binary to support installing into ruby 1.8 and 1.9 
  from the same gem
* Update to Sqlite 3.6.16 and fix errors returned by define_aggregate and 
  define_function based upon update

## Version 0.9.0 - 2009-04-05

### Enhancements

* Ruby 1.9 compatibility
* Update to SQLite 3.6.12
* Added support for the new SQLite Backup API, see Amalgalite::Database#replicate_to
* Added exclusive/immediate/deferred transaction helpers

## Version 0.8.0 - 2009-03-23

### Enhancements

* Add in support for obtaining limited schema information on temporary tables
  and indexes
* Add support for returning the primary key columns of a table
* Other miscellaneous items to support the ActiveRecord adapter

## Version 0.7.7 - 2009-03-03

### Bug Fixes

* roll back to SQLite 3.6.10 because of substr() bug in 3.6.11

## Version 0.7.6 - 2009-03-02

### Enhancements

* Update to SQLite 3.6.11

### Bug Fixes

* fix issues with the wrong error message appearing in statement closing
* incorrectly raise an exception if a transaction is started when rescuing an
  exception [reported by James Edwared Gray II]

## Version 0.7.5 - 2009-02-12

### Bug Fixes

* another ruby -w pass to clear up warnings
* force all tests to run with -w turned on

## Version 0.7.4 - 2009-02-08

### Bug Fixes

* fix Database#first_row_from not behaving the same as Database#execute() when
  there are no results. [reported by James Edward Gray II]

## Version 0.7.3 - 2009-02-08

### Enhancements

* added Database#first_row_from
* added Database#first_value_from

### Bug Fixes

* clean up ruby warnings when run with -w
* fix documenation on Database#execute

## Version 0.7.2 - 2009-01-24
### Enhancements

* added quoting and escaping of text support, used for database drivers
* added ability to access columns of the schame in original definition order

## Version 0.7.1 - 2009-01-18

### Enhancements

* added support for sqlite's nexted transactions which appeared in sqlite
* update to SQLite version 3.6.10
* added ability to set the SQLite temporary directory
* added amalgalite-pack --require-order

### Bug Fixes

* fix exception when accessing the special 'rowid' column
* fix internal require order list for use in packing

## Version 0.6.0 - 2009-01-10

### Enhancements

* Added ability to define custom SQL functions implemented in Ruby
* Added ability to define custom SQL aggregates implemented in Ruby
* Added support for Ruby busy handlers
* Added database 'interrupt' support
* Added support for Ruby progress handlers
* update to SQLite version 3.6.7

## Version 0.5.1 - 2008-11-30

### Enhancements

* update to SQLite version 3.6.6.2

## Version 0.5.0 - 2008-11-16

### Enhancements

* amalgalite-pack-into-db has been reworked into amalgalite-pack
* ruby code that is packed into a database for later requiring can now be
  compressed
* update to SQLite version 3.6.5

## Version 0.4.2 - 2008-10-12

### Enhancements

* release of windows gem

## Version 0.4.1 - 2008-09-28

### Enhancements

* update to SQLite3 version 3.6.3
* change rdoc template to darkfish

## Version 0.4.0 - 2008-09-14

### Enhancements
* update to SQLite3 version 3.6.2 and enable the RTree option by default
* Amalgalite::Requires module allowing ruby code to be 'required' from columns in an SQLite database
* Amagalite::Requires::Bootstrap extension module enabling low level boot
  strapping of the pure ruby Amalgalite code from an sqlite database
* more indepth information about indexes is available via the Index class
* add support for sqlite3_status and sqlite3_db_status information

### Bugfixes

* fix nil exception when using a declared_data_type on primary key column that
  has no declared_data_type
* when Database#transaction is passed a block, the return value is the return
  value of the block
* nested transactions are 'faked'.  Calling Database#transaction while
  Databased#in_transaction? is true does not result in an exception, but
  continues on in the current transaction.  
* raise LoadError if required in the same program as sqlite3-ruby.  These
  libraries conflict with each other.

## Version 0.2.4 - 2008-07-13

###  Bugfixes
* fix compilation when ruby is compiled without pthreads using 

## Version 0.2.3 - 2008-07-12

### Bugfixes
* make sure file permissions are all read before shipping gem

## Version 0.2.2 - 2008-07-12

### Bugfixes
* Database#pragma should accept a block just like Database#execute does
* convert to using extconf.rb instead of mkrf to enable compilation as a
  direct ruby extension in the ruby source tree

## Version 0.2.1 - 2008-07-05

### Bugfixes
* make sure that the pthread support in sqlite3 matches that of ruby
* fix schema reloading in the example scripts

## Version 0.2.0 - 2008-07-04

### Enhancements
* blob support, both incremental access and normal access
* added examples/gem_db.rb script demonstrating taps and prepared statements
* added examples/schema-info.rb script demonstrating meta information
* added examples/blob.rb demonstrating incremental blob IO
* added access to the SQLite3 errcode and errmsg api

### Bugfixes
* added taps.rb for requiring
* fixed prepared statement reset
* caught an error in executing prepared statements earlier in the process so the correct error is reported

## Version 0.1.0 - 2008-06-21

* Initial public release
