/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.collections.SynchronizedQueue;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;

public class NioBlockingSelector {
    private static final Log log = LogFactory.getLog(NioBlockingSelector.class);
    private static AtomicInteger threadCounter = new AtomicInteger(0);
    private final SynchronizedStack<KeyReference> keyReferenceStack = new SynchronizedStack();
    protected Selector sharedSelector;
    protected BlockPoller poller;

    public void open(Selector selector) {
        this.sharedSelector = selector;
        this.poller = new BlockPoller();
        this.poller.selector = this.sharedSelector;
        this.poller.setDaemon(true);
        this.poller.setName("NioBlockingSelector.BlockPoller-" + threadCounter.getAndIncrement());
        this.poller.start();
    }

    public void close() {
        if (this.poller != null) {
            this.poller.disable();
            this.poller.interrupt();
            this.poller = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer buf, NioChannel socket, long writeTimeout) throws IOException {
        SelectionKey key = socket.getIOChannel().keyFor(socket.getPoller().getSelector());
        if (key == null) {
            throw new IOException("Key no longer registered");
        }
        KeyReference reference = (KeyReference)this.keyReferenceStack.pop();
        if (reference == null) {
            reference = new KeyReference();
        }
        NioEndpoint.NioSocketWrapper att = (NioEndpoint.NioSocketWrapper)key.attachment();
        int written = 0;
        boolean timedout = false;
        int keycount = 1;
        long time = System.currentTimeMillis();
        try {
            while (!timedout && buf.hasRemaining()) {
                if (keycount > 0) {
                    int cnt = socket.write(buf);
                    if (cnt == -1) {
                        throw new EOFException();
                    }
                    written += cnt;
                    if (cnt > 0) {
                        time = System.currentTimeMillis();
                        continue;
                    }
                }
                try {
                    if (att.getWriteLatch() == null || att.getWriteLatch().getCount() == 0L) {
                        att.startWriteLatch(1);
                    }
                    this.poller.add(att, 4, reference);
                    if (writeTimeout < 0L) {
                        att.awaitWriteLatch(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    } else {
                        att.awaitWriteLatch(writeTimeout, TimeUnit.MILLISECONDS);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (att.getWriteLatch() != null && att.getWriteLatch().getCount() > 0L) {
                    keycount = 0;
                } else {
                    keycount = 1;
                    att.resetWriteLatch();
                }
                if (writeTimeout <= 0L || keycount != 0) continue;
                timedout = System.currentTimeMillis() - time >= writeTimeout;
            }
            if (timedout) {
                throw new SocketTimeoutException();
            }
        }
        finally {
            this.poller.remove(att, 4);
            if (timedout && reference.key != null) {
                this.poller.cancelKey(reference.key);
            }
            reference.key = null;
            this.keyReferenceStack.push((Object)reference);
        }
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer buf, NioChannel socket, long readTimeout) throws IOException {
        SelectionKey key = socket.getIOChannel().keyFor(socket.getPoller().getSelector());
        if (key == null) {
            throw new IOException("Key no longer registered");
        }
        KeyReference reference = (KeyReference)this.keyReferenceStack.pop();
        if (reference == null) {
            reference = new KeyReference();
        }
        NioEndpoint.NioSocketWrapper att = (NioEndpoint.NioSocketWrapper)key.attachment();
        int read = 0;
        boolean timedout = false;
        int keycount = 1;
        long time = System.currentTimeMillis();
        try {
            while (!(timedout || keycount > 0 && (read = socket.read(buf)) != 0)) {
                try {
                    if (att.getReadLatch() == null || att.getReadLatch().getCount() == 0L) {
                        att.startReadLatch(1);
                    }
                    this.poller.add(att, 1, reference);
                    if (readTimeout < 0L) {
                        att.awaitReadLatch(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    } else {
                        att.awaitReadLatch(readTimeout, TimeUnit.MILLISECONDS);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (att.getReadLatch() != null && att.getReadLatch().getCount() > 0L) {
                    keycount = 0;
                } else {
                    keycount = 1;
                    att.resetReadLatch();
                }
                if (readTimeout < 0L || keycount != 0) continue;
                timedout = System.currentTimeMillis() - time >= readTimeout;
            }
            if (timedout) {
                throw new SocketTimeoutException();
            }
        }
        finally {
            this.poller.remove(att, 1);
            if (timedout && reference.key != null) {
                this.poller.cancelKey(reference.key);
            }
            reference.key = null;
            this.keyReferenceStack.push((Object)reference);
        }
        return read;
    }

    public static class KeyReference {
        SelectionKey key = null;

        public void finalize() {
            if (this.key != null && this.key.isValid()) {
                log.warn((Object)"Possible key leak, cancelling key in the finalizer.");
                try {
                    this.key.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected static class BlockPoller
    extends Thread {
        protected volatile boolean run = true;
        protected Selector selector = null;
        protected final SynchronizedQueue<Runnable> events = new SynchronizedQueue();
        protected final AtomicInteger wakeupCounter = new AtomicInteger(0);

        protected BlockPoller() {
        }

        public void disable() {
            this.run = false;
            this.selector.wakeup();
        }

        public void cancelKey(SelectionKey key) {
            RunnableCancel r = new RunnableCancel(key);
            this.events.offer((Object)r);
            this.wakeup();
        }

        public void wakeup() {
            if (this.wakeupCounter.addAndGet(1) == 0) {
                this.selector.wakeup();
            }
        }

        public void cancel(SelectionKey sk, NioEndpoint.NioSocketWrapper key, int ops) {
            if (sk != null) {
                sk.cancel();
                sk.attach(null);
                if (4 == (ops & 4)) {
                    this.countDown(key.getWriteLatch());
                }
                if (1 == (ops & 1)) {
                    this.countDown(key.getReadLatch());
                }
            }
        }

        public void add(NioEndpoint.NioSocketWrapper key, int ops, KeyReference ref) {
            if (key == null) {
                return;
            }
            NioChannel nch = (NioChannel)key.getSocket();
            SocketChannel ch = nch.getIOChannel();
            if (ch == null) {
                return;
            }
            RunnableAdd r = new RunnableAdd(ch, key, ops, ref);
            this.events.offer((Object)r);
            this.wakeup();
        }

        public void remove(NioEndpoint.NioSocketWrapper key, int ops) {
            if (key == null) {
                return;
            }
            NioChannel nch = (NioChannel)key.getSocket();
            SocketChannel ch = nch.getIOChannel();
            if (ch == null) {
                return;
            }
            RunnableRemove r = new RunnableRemove(ch, key, ops);
            this.events.offer((Object)r);
            this.wakeup();
        }

        public boolean events() {
            Runnable r = null;
            int size = this.events.size();
            for (int i = 0; i < size && (r = (Runnable)this.events.poll()) != null; ++i) {
                r.run();
            }
            return size > 0;
        }

        @Override
        public void run() {
            block21: {
                block20: {
                    while (this.run) {
                        try {
                            Iterator<SelectionKey> iterator;
                            this.events();
                            int keyCount = 0;
                            try {
                                int i = this.wakeupCounter.get();
                                if (i > 0) {
                                    keyCount = this.selector.selectNow();
                                } else {
                                    this.wakeupCounter.set(-1);
                                    keyCount = this.selector.select(1000L);
                                }
                                this.wakeupCounter.set(0);
                                if (!this.run) {
                                    break;
                                }
                            }
                            catch (NullPointerException x) {
                                if (this.selector == null) {
                                    throw x;
                                }
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)"Possibly encountered sun bug 5076772 on windows JDK 1.5", (Throwable)x);
                                continue;
                            }
                            catch (CancelledKeyException x) {
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)"Possibly encountered sun bug 5076772 on windows JDK 1.5", (Throwable)x);
                                continue;
                            }
                            catch (Throwable x) {
                                ExceptionUtils.handleThrowable((Throwable)x);
                                log.error((Object)"", x);
                                continue;
                            }
                            Iterator<SelectionKey> iterator2 = iterator = keyCount > 0 ? this.selector.selectedKeys().iterator() : null;
                            while (this.run && iterator != null && iterator.hasNext()) {
                                SelectionKey sk = iterator.next();
                                NioEndpoint.NioSocketWrapper attachment = (NioEndpoint.NioSocketWrapper)sk.attachment();
                                try {
                                    iterator.remove();
                                    sk.interestOps(sk.interestOps() & ~sk.readyOps());
                                    if (sk.isReadable()) {
                                        this.countDown(attachment.getReadLatch());
                                    }
                                    if (!sk.isWritable()) continue;
                                    this.countDown(attachment.getWriteLatch());
                                }
                                catch (CancelledKeyException ckx) {
                                    sk.cancel();
                                    this.countDown(attachment.getReadLatch());
                                    this.countDown(attachment.getWriteLatch());
                                }
                            }
                        }
                        catch (Throwable t) {
                            log.error((Object)"", t);
                        }
                    }
                    this.events.clear();
                    if (this.selector.isOpen()) {
                        try {
                            this.selector.selectNow();
                        }
                        catch (Exception ignore) {
                            if (!log.isDebugEnabled()) break block20;
                            log.debug((Object)"", (Throwable)ignore);
                        }
                    }
                }
                try {
                    this.selector.close();
                }
                catch (Exception ignore) {
                    if (!log.isDebugEnabled()) break block21;
                    log.debug((Object)"", (Throwable)ignore);
                }
            }
        }

        public void countDown(CountDownLatch latch) {
            if (latch == null) {
                return;
            }
            latch.countDown();
        }

        public static class RunnableCancel
        implements Runnable {
            private final SelectionKey key;

            public RunnableCancel(SelectionKey key) {
                this.key = key;
            }

            @Override
            public void run() {
                this.key.cancel();
            }
        }

        private class RunnableRemove
        implements Runnable {
            private final SocketChannel ch;
            private final NioEndpoint.NioSocketWrapper key;
            private final int ops;

            public RunnableRemove(SocketChannel ch, NioEndpoint.NioSocketWrapper key, int ops) {
                this.ch = ch;
                this.key = key;
                this.ops = ops;
            }

            @Override
            public void run() {
                block11: {
                    SelectionKey sk = this.ch.keyFor(BlockPoller.this.selector);
                    try {
                        if (sk == null) {
                            if (4 == (this.ops & 4)) {
                                BlockPoller.this.countDown(this.key.getWriteLatch());
                            }
                            if (1 == (this.ops & 1)) {
                                BlockPoller.this.countDown(this.key.getReadLatch());
                            }
                        } else if (sk.isValid()) {
                            sk.interestOps(sk.interestOps() & ~this.ops);
                            if (4 == (this.ops & 4)) {
                                BlockPoller.this.countDown(this.key.getWriteLatch());
                            }
                            if (1 == (this.ops & 1)) {
                                BlockPoller.this.countDown(this.key.getReadLatch());
                            }
                            if (sk.interestOps() == 0) {
                                sk.cancel();
                                sk.attach(null);
                            }
                        } else {
                            sk.cancel();
                            sk.attach(null);
                        }
                    }
                    catch (CancelledKeyException cx) {
                        if (sk == null) break block11;
                        sk.cancel();
                        sk.attach(null);
                    }
                }
            }
        }

        private class RunnableAdd
        implements Runnable {
            private final SocketChannel ch;
            private final NioEndpoint.NioSocketWrapper key;
            private final int ops;
            private final KeyReference ref;

            public RunnableAdd(SocketChannel ch, NioEndpoint.NioSocketWrapper key, int ops, KeyReference ref) {
                this.ch = ch;
                this.key = key;
                this.ops = ops;
                this.ref = ref;
            }

            @Override
            public void run() {
                SelectionKey sk = this.ch.keyFor(BlockPoller.this.selector);
                try {
                    if (sk == null) {
                        this.ref.key = sk = this.ch.register(BlockPoller.this.selector, this.ops, this.key);
                    } else if (!sk.isValid()) {
                        BlockPoller.this.cancel(sk, this.key, this.ops);
                    } else {
                        sk.interestOps(sk.interestOps() | this.ops);
                    }
                }
                catch (CancelledKeyException cx) {
                    BlockPoller.this.cancel(sk, this.key, this.ops);
                }
                catch (ClosedChannelException cx) {
                    BlockPoller.this.cancel(null, this.key, this.ops);
                }
            }
        }
    }
}

