/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.util.List;
import java.util.Stack;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.VerticalBox;

public final class BreakFormula {
    public static Box split(Box box, float f, float f2) {
        if (box instanceof HorizontalBox) {
            return BreakFormula.split((HorizontalBox)box, f, f2);
        }
        if (box instanceof VerticalBox) {
            return BreakFormula.split((VerticalBox)box, f, f2);
        }
        return box;
    }

    public static Box split(HorizontalBox horizontalBox, float f, float f2) {
        VerticalBox verticalBox = new VerticalBox();
        HorizontalBox horizontalBox2 = null;
        Stack stack = new Stack();
        float f3 = -1.0f;
        while (horizontalBox.a > f && (f3 = BreakFormula.canBreak(stack, horizontalBox, f)) != horizontalBox.a) {
            Position position = (Position)stack.pop();
            HorizontalBox[] horizontalBoxArray = position.a.split(position.a - 1);
            HorizontalBox horizontalBox3 = horizontalBoxArray[0];
            horizontalBox2 = horizontalBoxArray[1];
            while (!stack.isEmpty()) {
                position = (Position)stack.pop();
                horizontalBoxArray = position.a.splitRemove(position.a);
                horizontalBoxArray[0].add(horizontalBox3);
                horizontalBoxArray[1].add(0, horizontalBox2);
                horizontalBox3 = horizontalBoxArray[0];
                horizontalBox2 = horizontalBoxArray[1];
            }
            verticalBox.add(horizontalBox3, f2);
            horizontalBox = horizontalBox2;
        }
        if (horizontalBox2 != null) {
            verticalBox.add(horizontalBox2, f2);
            return verticalBox;
        }
        return horizontalBox;
    }

    private static Box split(VerticalBox verticalBox, float f, float f2) {
        VerticalBox verticalBox2 = new VerticalBox();
        for (Box box : verticalBox.a) {
            verticalBox2.add(BreakFormula.split(box, f, f2));
        }
        return verticalBox2;
    }

    private static float canBreak(Stack stack, HorizontalBox horizontalBox, float f) {
        List list = horizontalBox.a;
        float[] fArray = new float[list.size() + 1];
        fArray[0] = 0.0f;
        for (int i = 0; i < list.size(); ++i) {
            Stack stack2;
            float f2;
            Box box = (Box)list.get(i);
            fArray[i + 1] = fArray[i] + box.a;
            if (!(fArray[i + 1] > f)) continue;
            int n = BreakFormula.getBreakPosition(horizontalBox, i);
            if (box instanceof HorizontalBox && (f2 = BreakFormula.canBreak(stack2 = new Stack(), (HorizontalBox)box, f - fArray[i])) != box.a && (fArray[i] + f2 <= f || n == -1)) {
                stack.push(new Position(i - 1, horizontalBox));
                stack.addAll(stack2);
                return fArray[i] + f2;
            }
            if (n == -1) continue;
            stack.push(new Position(n, horizontalBox));
            return fArray[n];
        }
        return (float)horizontalBox.a;
    }

    private static int getBreakPosition(HorizontalBox horizontalBox, int n) {
        int n2;
        if (horizontalBox.a == null) {
            return -1;
        }
        if (horizontalBox.a.size() == 1 && (Integer)horizontalBox.a.get(0) <= n) {
            return (Integer)horizontalBox.a.get(0);
        }
        for (n2 = 0; n2 < horizontalBox.a.size(); ++n2) {
            if ((Integer)horizontalBox.a.get(n2) <= n) continue;
            if (n2 == 0) {
                return -1;
            }
            return (Integer)horizontalBox.a.get(n2 - 1);
        }
        return (Integer)horizontalBox.a.get(n2 - 1);
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private static class Position {
        int a;
        HorizontalBox a;

        Position(int n, HorizontalBox horizontalBox) {
            this.a = n;
            this.a = horizontalBox;
        }
    }
}

