"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var rendering_1 = require("../../chart_types/xy_chart/rendering/rendering");
/**
 * Helper function to return array of rendered y1 values
 */
exports.getFilledNullData = function (data) {
    return data.filter(function (_a) {
        var y1 = _a.y1;
        return y1 === null;
    }).map(function (_a) {
        var filled = _a.filled;
        return filled && filled.y1;
    });
};
/**
 * Helper function to return array of rendered y1 values
 */
exports.getFilledNonNullData = function (data) {
    return data.filter(function (_a) {
        var y1 = _a.y1;
        return y1 !== null;
    }).map(function (_a) {
        var filled = _a.filled;
        return filled && filled.y1;
    });
};
/**
 * Helper function to return array of rendered x values
 */
exports.getXValueData = function (data) {
    return data.map(function (_a) {
        var x = _a.x;
        return x;
    });
};
/**
 * Returns value of `y1` or `filled.y1` or null
 */
exports.getYResolvedData = function (data) {
    return data.map(rendering_1.getYValue);
};
//# sourceMappingURL=utils.js.map