// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepClass_FaceExplorer_HeaderFile
#define _BRepClass_FaceExplorer_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <TopoDS_Face.hxx>
#include <TopExp_Explorer.hxx>
#include <Standard_Integer.hxx>
#include <Standard_Real.hxx>
#include <Standard_Boolean.hxx>
#include <TopAbs_Orientation.hxx>
class TopoDS_Face;
class gp_Pnt2d;
class gp_Lin2d;
class BRepClass_Edge;


//! Provide an   exploration of a  BRep Face   for the
//! classification. Return UV edges.
class BRepClass_FaceExplorer 
{
public:

  DEFINE_STANDARD_ALLOC

  
  Standard_EXPORT BRepClass_FaceExplorer(const TopoDS_Face& F);
  
  //! Should  return  True  if the  point  is  outside a
  //! bounding volume of the face.
  Standard_EXPORT   Standard_Boolean Reject (const gp_Pnt2d& P)  const;
  
  //! Returns  in <L>, <Par>  a segment having at least
  //! one  intersection  with  the   face  boundary  to
  //! compute  intersections.
  Standard_EXPORT   Standard_Boolean Segment (const gp_Pnt2d& P, gp_Lin2d& L, Standard_Real& Par) ;
  
  //! Returns  in <L>, <Par>  a segment having at least
  //! one  intersection  with  the   face  boundary  to
  //! compute  intersections. Each call gives another segment.
  Standard_EXPORT   Standard_Boolean OtherSegment (const gp_Pnt2d& P, gp_Lin2d& L, Standard_Real& Par) ;
  
  //! Starts an exploration of the wires.
  Standard_EXPORT   void InitWires() ;
  
  //! Returns True if there is  a current wire.
      Standard_Boolean MoreWires()  const;
  
  //! Sets the explorer  to the  next  wire.
      void NextWire() ;
  
  //! Returns True  if the wire  bounding volume does not
  //! intersect the segment.
  Standard_EXPORT   Standard_Boolean RejectWire (const gp_Lin2d& L, const Standard_Real Par)  const;
  
  //! Starts an exploration of the  edges of the current
  //! wire.
  Standard_EXPORT   void InitEdges() ;
  
  //! Returns True if there is a current edge.
      Standard_Boolean MoreEdges()  const;
  
  //! Sets the explorer  to the  next  edge.
      void NextEdge() ;
  
  //! Returns True  if the edge  bounding volume does not
  //! intersect the segment.
  Standard_EXPORT   Standard_Boolean RejectEdge (const gp_Lin2d& L, const Standard_Real Par)  const;
  
  //! Current edge in current wire and its orientation.
  Standard_EXPORT   void CurrentEdge (BRepClass_Edge& E, TopAbs_Orientation& Or)  const;




protected:





private:



  TopoDS_Face myFace;
  TopExp_Explorer myWExplorer;
  TopExp_Explorer myEExplorer;
  Standard_Integer myCurEdgeInd;
  Standard_Real myCurEdgePar;


};


#include <BRepClass_FaceExplorer.lxx>





#endif // _BRepClass_FaceExplorer_HeaderFile
