/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util.codec;

import com.cloudhopper.commons.util.codec.URLDecoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.BitSet;

public class URLCodec {
    protected static final BitSet UNRESERVED;
    protected static final Charset UTF_8;

    public static CharSequence encode(CharSequence in) throws IOException {
        if (in == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(in.length() * 2);
        URLCodec.encode(in, (Appendable)sb);
        return sb;
    }

    public static void encode(CharSequence in, Appendable out) throws IOException {
        URLCodec.encode(in, UTF_8, out);
    }

    public static void encode(CharSequence in, Charset charset, Appendable out) throws IOException {
        CharBuffer cb;
        if (in instanceof CharBuffer) {
            cb = (CharBuffer)in;
        } else if (in != null) {
            cb = CharBuffer.wrap(in);
        } else {
            return;
        }
        URLCodec.encode(charset.encode(cb), out);
    }

    public static void encode(ByteBuffer in, Appendable out) throws IOException {
        if (in == null) {
            return;
        }
        while (in.hasRemaining()) {
            int b = in.get();
            if (b < 0) {
                b += 256;
            }
            if (UNRESERVED.get(b)) {
                if (b == 32) {
                    b = 43;
                }
                out.append((char)b);
                continue;
            }
            out.append('%');
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            out.append(hex1);
            out.append(hex2);
        }
        in.clear();
    }

    public static CharSequence decode(CharSequence in) throws IOException {
        if (in == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(in.length());
        URLCodec.decode(in, sb);
        return sb;
    }

    public static void decode(CharSequence in, Appendable out) throws IOException {
        URLCodec.decode(in, UTF_8, out);
    }

    public static void decode(CharSequence in, Charset charset, Appendable out) throws IOException {
        if (in == null) {
            return;
        }
        URLDecoder ud = new URLDecoder(out, in.length(), charset);
        ud.append(in);
        ud.close();
    }

    public static byte[] decodeToBytes(CharSequence in) throws IOException {
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(in.length());
        URLCodec.decode(in, baos);
        return baos.toByteArray();
    }

    public static void decode(CharSequence in, OutputStream out) throws IOException {
        CharBuffer cb;
        if (in instanceof CharBuffer) {
            cb = (CharBuffer)in;
        } else if (in != null) {
            cb = CharBuffer.wrap(in);
        } else {
            return;
        }
        while (cb.hasRemaining()) {
            char c = cb.get();
            if (c == '+') {
                out.write(32);
                continue;
            }
            if (c == '%') {
                int x = Character.digit(cb.get(), 16);
                int y = Character.digit(cb.get(), 16);
                if (x == -1 || y == -1) {
                    throw new IOException("Invalid URL encoding");
                }
                out.write((x << 4) + y);
                continue;
            }
            out.write(c);
        }
    }

    static {
        int i;
        UNRESERVED = new BitSet(256);
        UTF_8 = Charset.forName("UTF-8");
        for (i = 97; i <= 122; ++i) {
            UNRESERVED.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            UNRESERVED.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            UNRESERVED.set(i);
        }
        UNRESERVED.set(45);
        UNRESERVED.set(95);
        UNRESERVED.set(46);
        UNRESERVED.set(42);
        UNRESERVED.set(32);
    }
}

