/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.json.Json;
import javax.json.JsonObject;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class OwnTracksProtocolDecoder
extends BaseHttpProtocolDecoder {
    public OwnTracksProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        DeviceSession deviceSession;
        String uniqueId;
        FullHttpRequest request = (FullHttpRequest)msg;
        JsonObject root = Json.createReader((Reader)new StringReader(request.content().toString(StandardCharsets.US_ASCII))).readObject();
        if (!root.containsKey((Object)"_type")) {
            this.sendResponse(channel, HttpResponseStatus.OK);
            return null;
        }
        if (!root.getString("_type").equals("location") && !root.getString("_type").equals("lwt")) {
            this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
            return null;
        }
        Position position = new Position(this.getProtocolName());
        if (root.containsKey((Object)"topic")) {
            uniqueId = root.getString("topic");
            if (root.containsKey((Object)"tid")) {
                position.set("tid", root.getString("tid"));
            }
        } else {
            uniqueId = root.getString("tid");
        }
        if ((deviceSession = this.getDeviceSession(channel, remoteAddress, uniqueId)) == null) {
            this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
            return null;
        }
        if (root.getString("_type").equals("lwt")) {
            this.sendResponse(channel, HttpResponseStatus.OK);
            return null;
        }
        if (root.containsKey((Object)"t") && root.getString("t").equals("p")) {
            this.sendResponse(channel, HttpResponseStatus.OK);
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(new Date(root.getJsonNumber("tst").longValue() * 1000L));
        if (root.containsKey((Object)"sent")) {
            position.setDeviceTime(new Date(root.getJsonNumber("sent").longValue() * 1000L));
        }
        position.setValid(true);
        position.setLatitude(root.getJsonNumber("lat").doubleValue());
        position.setLongitude(root.getJsonNumber("lon").doubleValue());
        if (root.containsKey((Object)"vel")) {
            position.setSpeed(UnitsConverter.knotsFromKph(root.getInt("vel")));
        }
        if (root.containsKey((Object)"alt")) {
            position.setAltitude(root.getInt("alt"));
        }
        if (root.containsKey((Object)"cog")) {
            position.setCourse(root.getInt("cog"));
        }
        if (root.containsKey((Object)"acc")) {
            position.setAccuracy(root.getInt("acc"));
        }
        if (root.containsKey((Object)"t")) {
            String trigger = root.getString("t");
            position.set("t", trigger);
            Integer reportType = -1;
            if (root.containsKey((Object)"rty")) {
                reportType = root.getInt("rty");
            }
            this.setEventOrAlarm(position, trigger, reportType);
        }
        if (root.containsKey((Object)"batt")) {
            position.set("batteryLevel", root.getInt("batt"));
        }
        if (root.containsKey((Object)"uext")) {
            position.set("power", root.getJsonNumber("uext").doubleValue());
        }
        if (root.containsKey((Object)"ubatt")) {
            position.set("battery", root.getJsonNumber("ubatt").doubleValue());
        }
        if (root.containsKey((Object)"vin")) {
            position.set("vin", root.getString("vin"));
        }
        if (root.containsKey((Object)"name")) {
            position.set("vin", root.getString("name"));
        }
        if (root.containsKey((Object)"rpm")) {
            position.set("rpm", root.getInt("rpm"));
        }
        if (root.containsKey((Object)"ign")) {
            position.set("ignition", root.getBoolean("ign"));
        }
        if (root.containsKey((Object)"motion")) {
            position.set("motion", root.getBoolean("motion"));
        }
        if (root.containsKey((Object)"odometer")) {
            position.set("odometer", root.getJsonNumber("odometer").doubleValue() * 1000.0);
        }
        if (root.containsKey((Object)"hmc")) {
            position.set("hours", root.getJsonNumber("hmc").doubleValue() / 3600.0);
        }
        if (root.containsKey((Object)"anum")) {
            Integer numberOfAnalogueInputs = root.getInt("anum");
            Integer i = 0;
            while (i < numberOfAnalogueInputs) {
                String indexString = String.format("%02d", i);
                if (root.containsKey((Object)("adda-" + indexString))) {
                    position.set("adc" + (i + 1), root.getString("adda-" + indexString));
                }
                if (root.containsKey((Object)("temp_c-" + indexString))) {
                    position.set("temp" + (i + 1), root.getJsonNumber("temp_c-" + indexString).doubleValue());
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        this.sendResponse(channel, HttpResponseStatus.OK);
        return position;
    }

    private void setEventOrAlarm(Position position, String trigger, Integer reportType) {
        block11 : switch (trigger) {
            case "9": {
                position.set("alarm", "lowBattery");
                break;
            }
            case "1": {
                position.set("alarm", "powerOn");
                break;
            }
            case "i": {
                position.set("ignition", true);
                break;
            }
            case "I": {
                position.set("ignition", false);
                break;
            }
            case "E": {
                position.set("alarm", "powerRestored");
                break;
            }
            case "e": {
                position.set("alarm", "powerCut");
                break;
            }
            case "!": {
                position.set("alarm", "tow");
                break;
            }
            case "s": {
                position.set("alarm", "overspeed");
                break;
            }
            case "h": {
                switch (reportType) {
                    case 0: 
                    case 3: {
                        position.set("alarm", "hardBraking");
                        break block11;
                    }
                    case 1: 
                    case 4: {
                        position.set("alarm", "hardAcceleration");
                        break block11;
                    }
                }
                position.set("alarm", "hardCornering");
                break;
            }
        }
    }
}

