/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db.paros;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordTag;
import org.parosproxy.paros.db.TableTag;
import org.parosproxy.paros.db.paros.ParosAbstractTable;

public class ParosTableTag
extends ParosAbstractTable
implements TableTag {
    private static final String TABLE_NAME = "TAG";
    private static final String TAGID = "TAGID";
    private static final String HISTORYID = "HISTORYID";
    private static final String TAG = "TAG";
    private PreparedStatement psRead = null;
    private PreparedStatement psInsertTag = null;
    private CallableStatement psGetIdLastInsert = null;
    private PreparedStatement psGetTagsForHistoryId = null;
    private PreparedStatement psDeleteTag = null;
    private PreparedStatement psDeleteTagsForHistoryId = null;
    private PreparedStatement psGetAllTags = null;

    @Override
    protected void reconnect(Connection conn) throws DatabaseException {
        try {
            if (!DbUtils.hasTable(conn, "TAG")) {
                DbUtils.execute(conn, "CREATE cached TABLE TAG (tagid bigint generated by default as identity (start with 1), historyid bigint not null, tag varchar(1024) default '')");
            }
            this.psRead = conn.prepareStatement("SELECT * FROM TAG WHERE TAGID = ?");
            this.psInsertTag = conn.prepareStatement("INSERT INTO TAG (HISTORYID,TAG) VALUES (?, ?)");
            this.psGetIdLastInsert = conn.prepareCall("CALL IDENTITY();");
            this.psDeleteTag = conn.prepareStatement("DELETE FROM TAG WHERE HISTORYID = ? AND TAG = ?");
            this.psGetTagsForHistoryId = conn.prepareStatement("SELECT * FROM TAG WHERE HISTORYID = ?");
            this.psDeleteTagsForHistoryId = conn.prepareStatement("DELETE FROM TAG WHERE HISTORYID = ?");
            this.psGetAllTags = conn.prepareStatement("SELECT DISTINCT TAG FROM TAG ORDER BY TAG");
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized RecordTag read(long tagId) throws DatabaseException {
        try {
            this.psRead.setLong(1, tagId);
            try (ResultSet rs = this.psRead.executeQuery();){
                RecordTag result;
                RecordTag recordTag = result = this.build(rs);
                return recordTag;
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized RecordTag insert(long historyId, String tag) throws DatabaseException {
        try {
            this.psInsertTag.setLong(1, historyId);
            this.psInsertTag.setString(2, tag);
            this.psInsertTag.executeUpdate();
            try (ResultSet rs = this.psGetIdLastInsert.executeQuery();){
                rs.next();
                long id = rs.getLong(1);
                RecordTag recordTag = this.read(id);
                return recordTag;
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized void delete(long historyId, String tag) throws DatabaseException {
        try {
            this.psDeleteTag.setLong(1, historyId);
            this.psDeleteTag.setString(2, tag);
            this.psDeleteTag.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized List<RecordTag> getTagsForHistoryID(long historyId) throws DatabaseException {
        try {
            ArrayList<RecordTag> result = new ArrayList<RecordTag>();
            this.psGetTagsForHistoryId.setLong(1, historyId);
            try (ResultSet rs = this.psGetTagsForHistoryId.executeQuery();){
                while (rs.next()) {
                    result.add(new RecordTag(rs.getLong(TAGID), rs.getLong(TAGID), rs.getString("TAG")));
                }
            }
            return result;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public List<String> getAllTags() throws DatabaseException {
        try {
            ArrayList<String> result = new ArrayList<String>();
            try (ResultSet rs = this.psGetAllTags.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString("TAG"));
                }
            }
            return result;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized void deleteTagsForHistoryID(long historyId) throws DatabaseException {
        try {
            this.psDeleteTagsForHistoryId.setLong(1, historyId);
            this.psDeleteTagsForHistoryId.execute();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    private RecordTag build(ResultSet rs) throws SQLException {
        RecordTag rt = null;
        if (rs.next()) {
            rt = new RecordTag(rs.getLong(TAGID), rs.getLong(HISTORYID), rs.getString("TAG"));
        }
        return rt;
    }
}

