/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.ArrayList;
import java.util.List;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Operator;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.WrongNumberOfArgumentsException;

public class ArgumentListProcessor {
    private static final int STATE_REQUIRED = 0;
    private static final int STATE_OPTIONAL = 1;
    private static final int STATE_KEYWORD = 2;
    private static final int STATE_REST = 3;
    private static final int STATE_AUX = 4;
    private Param[] requiredParameters = new Param[0];
    private Param[] optionalParameters = this.requiredParameters;
    private KeywordParam[] keywordParameters = new KeywordParam[0];
    private Param[] auxVars = this.requiredParameters;
    private Param[] positionalParameters = this.requiredParameters;
    private Symbol restVar;
    private Param restParam;
    private Symbol envVar;
    private Param envParam;
    private int arity;
    private int minArgs;
    private int maxArgs;
    private Symbol[] variables = new Symbol[0];
    private boolean[] specials = new boolean[0];
    private boolean andKey;
    private boolean allowOtherKeys;
    private final ArgumentMatcher matcher;
    private boolean matcherNeedsEnv;
    private Operator function;

    public ArgumentListProcessor(Operator fun, int requiredCount, OptionalParam[] optional, KeywordParam[] keyword, boolean key, boolean moreKeys, Symbol rest) {
        this.function = fun;
        this.requiredParameters = new RequiredParam[requiredCount];
        this.positionalParameters = new Param[requiredCount + optional.length + (rest != null ? 1 : 0)];
        RequiredParam r = new RequiredParam();
        for (int i = 0; i < requiredCount; ++i) {
            this.requiredParameters[i] = r;
            this.positionalParameters[i] = r;
        }
        this.optionalParameters = optional;
        System.arraycopy(optional, 0, this.positionalParameters, requiredCount, optional.length);
        this.restVar = rest;
        if (this.restVar != null) {
            this.positionalParameters[requiredCount + optional.length] = this.restParam = new RestParam(rest, false);
        }
        this.andKey = key;
        this.allowOtherKeys = moreKeys;
        this.keywordParameters = keyword;
        this.auxVars = new Param[0];
        this.variables = this.extractVariables();
        this.specials = new boolean[this.variables.length];
        this.minArgs = this.requiredParameters.length;
        this.maxArgs = rest == null && !this.allowOtherKeys ? this.minArgs + this.optionalParameters.length + 2 * this.keywordParameters.length : -1;
        this.arity = rest == null && !this.allowOtherKeys && !this.andKey && this.optionalParameters.length == 0 ? this.maxArgs : -1;
        this.matcher = keyword.length == 0 ? new FastMatcher() : new SlowMatcher();
    }

    /*
     * WARNING - void declaration
     */
    public ArgumentListProcessor(Operator fun, LispObject lambdaList, LispObject specials, LambdaListType type) {
        this.function = fun;
        boolean _andKey = false;
        boolean _allowOtherKeys = false;
        if (lambdaList instanceof Cons) {
            void var10_14;
            int length = lambdaList.length();
            ArrayList<RequiredParam> required = null;
            ArrayList<OptionalParam> optional = null;
            Object var10_13 = null;
            ArrayList<AuxParam> aux = null;
            int state = 0;
            LispObject remaining = lambdaList;
            if (remaining.car() == Symbol.AND_WHOLE) {
                if (type == LambdaListType.ORDINARY) {
                    Lisp.program_error("&WHOLE not allowed in ordinary lambda lists.");
                } else {
                    remaining = remaining.cdr().cdr();
                }
            }
            while (remaining != Lisp.NIL) {
                LispObject obj = remaining.car();
                if (obj instanceof Symbol) {
                    if (obj == Symbol.AND_WHOLE) {
                        if (type == LambdaListType.ORDINARY) {
                            Lisp.program_error("&WHOLE not allowed in ordinary lambda lists.");
                        } else {
                            Lisp.program_error("&WHOLE must appear first in macro lambda list.");
                        }
                    }
                    if (state == 4) {
                        if (aux == null) {
                            aux = new ArrayList<AuxParam>();
                        }
                        aux.add(new AuxParam((Symbol)obj, Lisp.isSpecial((Symbol)obj, specials), Lisp.NIL));
                    } else if (obj == Symbol.AND_OPTIONAL) {
                        state = 1;
                        this.arity = -1;
                    } else if (obj == Symbol.AND_REST || obj == Symbol.AND_BODY) {
                        LispObject remainingcar;
                        if (_andKey) {
                            Lisp.program_error("&REST/&BODY must precede &KEY.");
                        }
                        if (type == LambdaListType.ORDINARY && obj == Symbol.AND_BODY) {
                            Lisp.program_error("&BODY not allowed in ordinary lambda lists.");
                        }
                        state = 3;
                        this.arity = -1;
                        this.maxArgs = -1;
                        if ((remaining = remaining.cdr()) == Lisp.NIL) {
                            Lisp.program_error("&REST/&BODY must be followed by a variable.");
                        }
                        if (this.restVar != null) {
                            Lisp.program_error("&REST/&BODY may occur only once.");
                        }
                        if ((remainingcar = remaining.car()) instanceof Symbol) {
                            this.restVar = (Symbol)remainingcar;
                            this.restParam = new RestParam(this.restVar, Lisp.isSpecial(this.restVar, specials));
                        } else {
                            Lisp.program_error("&REST/&BODY must be followed by a variable.");
                        }
                    } else if (obj == Symbol.AND_ENVIRONMENT) {
                        if (type == LambdaListType.ORDINARY) {
                            Lisp.program_error("&ENVIRONMENT not allowed in ordinary lambda lists.");
                        }
                        remaining = remaining.cdr();
                        this.envVar = (Symbol)remaining.car();
                        this.envParam = new EnvironmentParam(this.envVar, Lisp.isSpecial(this.envVar, specials));
                        this.arity = -1;
                    } else if (obj == Symbol.AND_KEY) {
                        state = 2;
                        _andKey = true;
                        this.arity = -1;
                    } else if (obj == Symbol.AND_ALLOW_OTHER_KEYS) {
                        _allowOtherKeys = true;
                        this.maxArgs = -1;
                    } else if (obj == Symbol.AND_AUX) {
                        state = 4;
                        this.arity = -1;
                    } else if (state == 1) {
                        if (optional == null) {
                            optional = new ArrayList();
                        }
                        optional.add(new OptionalParam((Symbol)obj, Lisp.isSpecial((Symbol)obj, specials), null, false, Lisp.NIL));
                        if (this.maxArgs >= 0) {
                            ++this.maxArgs;
                        }
                    } else if (state == 2) {
                        if (var10_14 == null) {
                            ArrayList arrayList = new ArrayList();
                        }
                        var10_14.add(new KeywordParam((Symbol)obj, Lisp.isSpecial((Symbol)obj, specials), null, false, Lisp.NIL, null));
                        if (this.maxArgs >= 0) {
                            this.maxArgs += 2;
                        }
                    } else {
                        if (state != 0) {
                            Lisp.program_error("required parameters cannot appear after &REST/&BODY.");
                        }
                        if (required == null) {
                            required = new ArrayList<RequiredParam>();
                        }
                        required.add(new RequiredParam((Symbol)obj, Lisp.isSpecial((Symbol)obj, specials)));
                        if (this.maxArgs >= 0) {
                            ++this.maxArgs;
                        }
                    }
                } else if (obj instanceof Cons) {
                    LispObject initForm;
                    Symbol sym;
                    if (state == 4) {
                        sym = Lisp.checkSymbol(obj.car());
                        initForm = obj.cadr();
                        Debug.assertTrue(initForm != null);
                        if (aux == null) {
                            aux = new ArrayList();
                        }
                        aux.add(new AuxParam(sym, Lisp.isSpecial(sym, specials), initForm));
                    } else if (state == 1) {
                        sym = Lisp.checkSymbol(obj.car());
                        initForm = obj.cadr();
                        Symbol svar = Lisp.checkSymbol(obj.cdr().cdr().car());
                        if (optional == null) {
                            optional = new ArrayList<OptionalParam>();
                        }
                        optional.add(new OptionalParam(sym, Lisp.isSpecial(sym, specials), svar == Lisp.NIL ? null : svar, Lisp.isSpecial(svar, specials), initForm));
                        if (this.maxArgs >= 0) {
                            ++this.maxArgs;
                        }
                    } else if (state == 2) {
                        Symbol var;
                        Symbol keyword;
                        LispObject initForm2 = Lisp.NIL;
                        Symbol svar = Lisp.NIL;
                        LispObject first = obj.car();
                        if (first instanceof Cons) {
                            keyword = Lisp.checkSymbol(first.car());
                            var = Lisp.checkSymbol(first.cadr());
                        } else {
                            var = Lisp.checkSymbol(first);
                            keyword = Lisp.PACKAGE_KEYWORD.intern(var.name);
                        }
                        obj = obj.cdr();
                        if (obj != Lisp.NIL) {
                            initForm2 = obj.car();
                            if ((obj = obj.cdr()) != Lisp.NIL) {
                                svar = Lisp.checkSymbol(obj.car());
                            }
                        }
                        if (var10_14 == null) {
                            ArrayList arrayList = new ArrayList();
                        }
                        var10_14.add(new KeywordParam(var, Lisp.isSpecial(var, specials), svar == Lisp.NIL ? null : svar, Lisp.isSpecial(svar, specials), initForm2, keyword));
                        if (this.maxArgs >= 0) {
                            this.maxArgs += 2;
                        }
                    } else {
                        ArgumentListProcessor.invalidParameter(obj);
                    }
                } else {
                    ArgumentListProcessor.invalidParameter(obj);
                }
                remaining = remaining.cdr();
            }
            if (this.arity == 0) {
                this.arity = length;
            }
            ArrayList<Param> positional = new ArrayList<Param>();
            if (this.envParam != null) {
                positional.add(this.envParam);
            }
            if (required != null) {
                this.requiredParameters = new Param[required.size()];
                required.toArray(this.requiredParameters);
                positional.addAll(required);
            }
            if (optional != null) {
                this.optionalParameters = new Param[optional.size()];
                optional.toArray(this.optionalParameters);
                positional.addAll(optional);
            }
            if (this.restParam != null) {
                positional.add(this.restParam);
            }
            if (var10_14 != null) {
                this.keywordParameters = new KeywordParam[var10_14.size()];
                var10_14.toArray(this.keywordParameters);
            }
            if (aux != null) {
                this.auxVars = new Param[aux.size()];
                this.auxVars = aux.toArray(this.auxVars);
            }
            this.positionalParameters = positional.toArray(this.positionalParameters);
        } else {
            Debug.assertTrue(lambdaList == Lisp.NIL);
            this.arity = 0;
            this.maxArgs = 0;
        }
        this.andKey = _andKey;
        this.allowOtherKeys = _allowOtherKeys;
        this.minArgs = this.requiredParameters.length;
        if (this.arity >= 0) {
            Debug.assertTrue(this.arity == this.minArgs);
        }
        this.variables = this.extractVariables();
        this.specials = new boolean[this.variables.length];
        for (int i = 0; i < this.variables.length; ++i) {
            this.specials[i] = Lisp.isSpecial(this.variables[i], specials);
        }
        for (Param param : this.positionalParameters) {
            if (!param.needsEnvironment()) continue;
            this.matcherNeedsEnv = true;
            break;
        }
        if (!this.matcherNeedsEnv) {
            for (Param param : this.keywordParameters) {
                if (!param.needsEnvironment()) continue;
                this.matcherNeedsEnv = true;
                break;
            }
        }
        if (!this.matcherNeedsEnv) {
            for (Param param : this.auxVars) {
                if (!param.needsEnvironment()) continue;
                this.matcherNeedsEnv = true;
                break;
            }
        }
        this.matcher = this.keywordParameters.length == 0 ? new FastMatcher() : new SlowMatcher();
    }

    public void setFunction(Operator fun) {
        this.function = fun;
    }

    public LispObject[] match(LispObject[] args, Environment _environment, Environment env, LispThread thread) {
        if (this.matcherNeedsEnv) {
            if (thread == null) {
                thread = LispThread.currentThread();
            }
            env = new Environment(env == null ? _environment : env);
        }
        LispObject[] rv = this.matcher.match(args, _environment, env, thread);
        for (int i = 0; i < rv.length; ++i) {
            Debug.assertTrue(rv[i] != null);
        }
        return rv;
    }

    public void bindVars(LispObject[] values, Environment env, LispThread thread) {
        for (int i = 0; i < this.variables.length; ++i) {
            Symbol var = this.variables[i];
            Lisp.bindArg(this.specials[i] || var.isSpecialVariable(), var, values[i], env, thread);
        }
    }

    public Symbol[] freeSpecials(LispObject specials) {
        ArrayList<Symbol> list = new ArrayList<Symbol>();
        block0: while (specials != Lisp.NIL) {
            Symbol special = (Symbol)specials.car();
            specials = specials.cdr();
            for (Symbol v : this.variables) {
                if (v == special) continue block0;
            }
            list.add(special);
        }
        Symbol[] rv = new Symbol[list.size()];
        return list.toArray(rv);
    }

    public int getArity() {
        return this.arity;
    }

    public int getMinArgs() {
        return this.minArgs;
    }

    public int getMaxArgs() {
        return this.maxArgs;
    }

    public Symbol[] getVariables() {
        return this.variables;
    }

    private static void invalidParameter(LispObject obj) {
        Lisp.program_error(obj.princToString() + " may not be used as a variable in a lambda list.");
    }

    private Symbol[] extractVariables() {
        ArrayList vars = new ArrayList();
        for (Param param : this.positionalParameters) {
            param.addVars(vars);
        }
        for (Param param : this.keywordParameters) {
            param.addVars(vars);
        }
        for (Param param : this.auxVars) {
            param.addVars(vars);
        }
        Symbol[] array = new Symbol[vars.size()];
        vars.toArray(array);
        return array;
    }

    private static InitForm createInitForm(LispObject form) {
        if (form.constantp()) {
            if (form instanceof Symbol) {
                return new ConstantInitForm(form.getSymbolValue());
            }
            if (form instanceof Cons) {
                Debug.assertTrue(form.car() == Symbol.QUOTE);
                return new ConstantInitForm(form.cadr());
            }
            return new ConstantInitForm(form);
        }
        return new NonConstantInitForm(form);
    }

    private static class AuxParam
    extends Param {
        Symbol var;
        boolean special;
        InitForm initform;

        AuxParam(Symbol var, boolean special, LispObject form) {
            this.var = var;
            this.special = special;
            this.initform = ArgumentListProcessor.createInitForm(form);
        }

        @Override
        void addVars(List vars) {
            vars.add(this.var);
        }

        @Override
        int assign(int index, LispObject[] array, ArgList args, Environment ext, LispThread thread) {
            array[index++] = this.initform.getValue(ext, thread);
            if (ext != null) {
                Lisp.bindArg(this.special, this.var, array[index - 1], ext, thread);
            }
            return index;
        }

        @Override
        boolean needsEnvironment() {
            return this.initform.needsEnvironment();
        }
    }

    public static class KeywordParam
    extends OptionalParam {
        public Symbol keyword;

        public KeywordParam(boolean suppliedVar, LispObject form, Symbol keyword) {
            this(Lisp.T, false, suppliedVar ? Lisp.T : null, false, form, keyword);
        }

        public KeywordParam(Symbol var, boolean special, Symbol suppliedVar, boolean suppliedSpecial, LispObject form, Symbol keyword) {
            super(var, special, suppliedVar, suppliedSpecial, form);
            this.keyword = keyword == null ? Lisp.PACKAGE_KEYWORD.intern(var.getName()) : keyword;
        }

        @Override
        int assign(int index, LispObject[] array, ArgList args, Environment ext, LispThread thread) {
            return super.assign(index, array, args.findKeywordArg(this.keyword, null), ext, thread);
        }
    }

    private static class RestParam
    extends Param {
        Symbol var;
        boolean special;

        RestParam(Symbol var, boolean special) {
            this.var = var;
            this.special = special;
        }

        @Override
        int assign(int index, LispObject[] array, ArgList args, Environment ext, LispThread thread) {
            array[index++] = args.rest();
            if (ext != null) {
                Lisp.bindArg(this.special, this.var, array[index - 1], ext, thread);
            }
            return index;
        }

        @Override
        void addVars(List vars) {
            vars.add(this.var);
        }
    }

    public static class OptionalParam
    extends Param {
        Symbol var;
        boolean special;
        Symbol suppliedVar;
        boolean suppliedSpecial;
        InitForm initForm;

        public OptionalParam(boolean suppliedVar, LispObject form) {
            this(Lisp.T, false, suppliedVar ? Lisp.T : null, false, form);
        }

        public OptionalParam(Symbol var, boolean special, Symbol suppliedVar, boolean suppliedSpecial, LispObject form) {
            this.var = var;
            this.special = special;
            this.suppliedVar = suppliedVar;
            this.suppliedSpecial = suppliedSpecial;
            this.initForm = ArgumentListProcessor.createInitForm(form);
        }

        @Override
        int assign(int index, LispObject[] array, ArgList args, Environment ext, LispThread thread) {
            LispObject value = args.consume();
            return this.assign(index, array, value, ext, thread);
        }

        int assign(int index, LispObject[] array, LispObject value, Environment ext, LispThread thread) {
            if (value == null) {
                int n = index++;
                LispObject lispObject = this.initForm.getValue(ext, thread);
                array[n] = lispObject;
                value = lispObject;
                if (this.suppliedVar != null) {
                    array[index++] = Lisp.NIL;
                }
            } else {
                array[index++] = value;
                if (this.suppliedVar != null) {
                    array[index++] = Lisp.T;
                }
            }
            if (ext != null) {
                Lisp.bindArg(this.special, this.var, value, ext, thread);
                if (this.suppliedVar != null) {
                    Lisp.bindArg(this.suppliedSpecial, this.suppliedVar, array[index - 1], ext, thread);
                }
            }
            return index;
        }

        @Override
        boolean needsEnvironment() {
            return this.initForm.needsEnvironment();
        }

        @Override
        void addVars(List vars) {
            vars.add(this.var);
            if (this.suppliedVar != null) {
                vars.add(this.suppliedVar);
            }
        }
    }

    public static class RequiredParam
    extends Param {
        Symbol var;
        boolean special;

        public RequiredParam() {
            this(Lisp.T, false);
        }

        public RequiredParam(Symbol var, boolean special) {
            this.var = var;
            this.special = special;
        }

        @Override
        int assign(int index, LispObject[] array, ArgList args, Environment ext, LispThread thread) {
            LispObject value = args.consume();
            if (ext != null) {
                Lisp.bindArg(this.special, this.var, value, ext, thread);
            }
            array[index++] = value;
            return index;
        }

        @Override
        void addVars(List vars) {
            vars.add(this.var);
        }
    }

    private static class EnvironmentParam
    extends Param {
        Symbol var;
        boolean special;

        EnvironmentParam(Symbol var, boolean special) {
            this.var = var;
            this.special = special;
        }

        @Override
        void addVars(List vars) {
            vars.add(this.var);
        }

        @Override
        int assign(int index, LispObject[] array, ArgList args, Environment ext, LispThread thread) {
            array[index++] = args.getEnvironment();
            if (ext != null) {
                Lisp.bindArg(this.special, this.var, (LispObject)args.getEnvironment(), ext, thread);
            }
            return index;
        }
    }

    private static class NonConstantInitForm
    extends InitForm {
        LispObject form;

        NonConstantInitForm(LispObject form) {
            this.form = form;
        }

        @Override
        LispObject getValue(Environment ext, LispThread thread) {
            return Lisp.eval(this.form, ext, thread);
        }

        @Override
        boolean needsEnvironment() {
            return true;
        }
    }

    private static class ConstantInitForm
    extends InitForm {
        LispObject value;

        ConstantInitForm(LispObject value) {
            this.value = value;
        }

        @Override
        LispObject getValue(Environment ext, LispThread thread) {
            return this.value;
        }
    }

    private static abstract class InitForm {
        private InitForm() {
        }

        abstract LispObject getValue(Environment var1, LispThread var2);

        boolean needsEnvironment() {
            return false;
        }
    }

    public static abstract class Param {
        abstract int assign(int var1, LispObject[] var2, ArgList var3, Environment var4, LispThread var5);

        boolean needsEnvironment() {
            return false;
        }

        abstract void addVars(List var1);
    }

    private static final class ArgList {
        final LispObject[] args;
        int argsConsumed = 0;
        final int len;
        final Environment env;

        ArgList(Environment environment, LispObject[] args) {
            this.args = args;
            this.len = args.length;
            this.env = environment;
        }

        void assertRemainderKeywords() {
            if ((this.len - this.argsConsumed & 1) == 1) {
                Lisp.program_error("Odd number of keyword arguments.");
            }
        }

        LispObject consume() {
            return this.argsConsumed < this.len ? this.args[this.argsConsumed++] : null;
        }

        boolean consumed() {
            return this.len == this.argsConsumed;
        }

        LispObject findKeywordArg(Symbol keyword, LispObject def) {
            for (int i = this.argsConsumed; i < this.len; i += 2) {
                if (this.args[i] != keyword) continue;
                return this.args[i + 1];
            }
            return def;
        }

        Environment getEnvironment() {
            return this.env;
        }

        LispObject rest() {
            LispObject rest = Lisp.NIL;
            int j = this.len;
            while (j-- > this.argsConsumed) {
                rest = new Cons(this.args[j], rest);
            }
            return rest;
        }
    }

    private class FastMatcher
    extends ArgumentMatcher {
        private FastMatcher() {
        }

        @Override
        LispObject[] match(LispObject[] args, Environment _environment, Environment env, LispThread thread) {
            int argsLength = args.length;
            if (ArgumentListProcessor.this.arity >= 0) {
                if (argsLength != ArgumentListProcessor.this.arity) {
                    Lisp.error(new WrongNumberOfArgumentsException(ArgumentListProcessor.this.function, Lisp.list(args), ArgumentListProcessor.this.arity));
                }
                return args;
            }
            if (argsLength < ArgumentListProcessor.this.minArgs) {
                Lisp.error(new WrongNumberOfArgumentsException(ArgumentListProcessor.this.function, ArgumentListProcessor.this.minArgs, -1));
            }
            ArgList arglist2 = new ArgList(_environment, args);
            LispObject[] array = new LispObject[ArgumentListProcessor.this.variables.length];
            int index = 0;
            for (Param p : ArgumentListProcessor.this.positionalParameters) {
                index = p.assign(index, array, arglist2, env, thread);
            }
            for (Param p : ArgumentListProcessor.this.auxVars) {
                index = p.assign(index, array, arglist2, env, thread);
            }
            if (ArgumentListProcessor.this.andKey && !arglist2.consumed()) {
                arglist2.assertRemainderKeywords();
                if (ArgumentListProcessor.this.allowOtherKeys) {
                    return array;
                }
                LispObject allowOtherKeysValue = arglist2.findKeywordArg(Keyword.ALLOW_OTHER_KEYS, null);
                if (allowOtherKeysValue == Lisp.NIL) {
                    LispObject key = arglist2.consume();
                    arglist2.consume();
                    if (key != Keyword.ALLOW_OTHER_KEYS) {
                        Lisp.program_error("Invalid keyword argument " + key.printObject() + ".");
                    }
                    allowOtherKeysValue = null;
                }
                if (allowOtherKeysValue != null) {
                    return array;
                }
            }
            if (!arglist2.consumed() && ArgumentListProcessor.this.restVar == null) {
                Lisp.error(new WrongNumberOfArgumentsException(ArgumentListProcessor.this.function));
            }
            return array;
        }
    }

    private class SlowMatcher
    extends ArgumentMatcher {
        private SlowMatcher() {
        }

        private LispObject[] _match(LispObject[] args, Environment _environment, Environment env, LispThread thread) {
            ArgList argslist = new ArgList(_environment, args);
            LispObject[] array = new LispObject[ArgumentListProcessor.this.variables.length];
            int index = 0;
            for (Param param : ArgumentListProcessor.this.positionalParameters) {
                index = param.assign(index, array, argslist, env, thread);
            }
            if (ArgumentListProcessor.this.andKey) {
                argslist.assertRemainderKeywords();
                for (Param param : ArgumentListProcessor.this.keywordParameters) {
                    index = param.assign(index, array, argslist, env, thread);
                }
            }
            for (Param param : ArgumentListProcessor.this.auxVars) {
                index = param.assign(index, array, argslist, env, thread);
            }
            if (ArgumentListProcessor.this.andKey) {
                if (ArgumentListProcessor.this.allowOtherKeys) {
                    return array;
                }
                if (!argslist.consumed()) {
                    LispObject allowOtherKeysValue = argslist.findKeywordArg(Keyword.ALLOW_OTHER_KEYS, Lisp.NIL);
                    if (allowOtherKeysValue != Lisp.NIL) {
                        return array;
                    }
                    block3: while (!argslist.consumed()) {
                        LispObject key = argslist.consume();
                        argslist.consume();
                        if (key == Keyword.ALLOW_OTHER_KEYS) continue;
                        for (KeywordParam k : ArgumentListProcessor.this.keywordParameters) {
                            if (k.keyword == key) continue block3;
                        }
                        Lisp.program_error("Unrecognized keyword argument " + key.printObject() + ".");
                    }
                }
            }
            if (ArgumentListProcessor.this.restVar == null && !argslist.consumed()) {
                Lisp.error(new WrongNumberOfArgumentsException(ArgumentListProcessor.this.function));
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        LispObject[] match(LispObject[] args, Environment _environment, Environment env, LispThread thread) {
            if (ArgumentListProcessor.this.arity >= 0) {
                if (args.length != ArgumentListProcessor.this.arity) {
                    Lisp.error(new WrongNumberOfArgumentsException(ArgumentListProcessor.this.function, Lisp.list(args), ArgumentListProcessor.this.arity));
                }
                return args;
            }
            if (args.length < ArgumentListProcessor.this.minArgs) {
                Lisp.error(new WrongNumberOfArgumentsException(ArgumentListProcessor.this.function, ArgumentListProcessor.this.minArgs, -1));
            }
            if (thread == null) {
                return this._match(args, _environment, env, thread);
            }
            SpecialBindingsMark mark = thread.markSpecialBindings();
            try {
                LispObject[] lispObjectArray = this._match(args, _environment, env, thread);
                return lispObjectArray;
            }
            finally {
                thread.resetSpecialBindings(mark);
            }
        }
    }

    private static abstract class ArgumentMatcher {
        private ArgumentMatcher() {
        }

        abstract LispObject[] match(LispObject[] var1, Environment var2, Environment var3, LispThread var4);
    }

    public static enum LambdaListType {
        ORDINARY,
        MACRO;

    }
}

