/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.osgi;

import org.apache.camel.TypeConverter;
import org.apache.camel.core.osgi.OsgiCamelContextHelper;
import org.apache.camel.core.osgi.OsgiFactoryFinderResolver;
import org.apache.camel.core.osgi.OsgiTypeConverter;
import org.apache.camel.core.osgi.utils.BundleContextUtils;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Registry;
import org.apache.camel.spring.SpringCamelContext;
import org.osgi.framework.BundleContext;
import org.springframework.context.ApplicationContext;

public class OsgiSpringCamelContext
extends SpringCamelContext {
    private final BundleContext bundleContext;

    public OsgiSpringCamelContext(ApplicationContext applicationContext, BundleContext bundleContext) {
        super(applicationContext);
        this.bundleContext = bundleContext;
        OsgiCamelContextHelper.osgiUpdate(this, bundleContext);
    }

    @Override
    protected TypeConverter createTypeConverter() {
        BundleContext ctx = BundleContextUtils.getBundleContext(this.getClass());
        if (ctx == null) {
            ctx = this.bundleContext;
        }
        FactoryFinder finder = new OsgiFactoryFinderResolver(this.bundleContext).resolveDefaultFactoryFinder(this.getClassResolver());
        return new OsgiTypeConverter(ctx, this.getInjector(), finder);
    }

    @Override
    protected Registry createRegistry() {
        return OsgiCamelContextHelper.wrapRegistry(this, super.createRegistry(), this.bundleContext);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        super.setManagementName(this.bundleContext.getBundle().getBundleId() + "-" + name);
    }
}

