/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.actions.AbstractFindReferencesDataTypeAction;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.program.model.data.DataType;
import javax.swing.tree.TreePath;

public class FindReferencesToDataTypeAction
extends AbstractFindReferencesDataTypeAction {
    public FindReferencesToDataTypeAction(DataTypeManagerPlugin plugin) {
        super(plugin.getTool(), "Find References To", plugin.getName(), DEFAULT_KEY_STROKE);
        String menuGroup = "ZVeryLast";
        this.setPopupMenuData(new MenuData(new String[]{"Find Uses of"}, null, menuGroup));
        this.setKeyBindingData(new KeyBindingData(70, 192));
    }

    @Override
    protected DataType getDataType(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return null;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths.length != 1) {
            return null;
        }
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        if (node instanceof DataTypeNode) {
            return ((DataTypeNode)node).getDataType();
        }
        return null;
    }
}

