/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.disassembler;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.disassembler.DisassemblerPlugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;

class MipsDisassembleAction
extends ListingContextAction {
    private DisassemblerPlugin plugin;
    private boolean disassembleMIPS16 = false;
    String groupName;

    public MipsDisassembleAction(DisassemblerPlugin plugin, String groupName, boolean disassembleMIPS16) {
        super("Disassemble " + (disassembleMIPS16 ? "MIPS16/Micromips" : "MIPS"), plugin.getName());
        this.groupName = groupName;
        this.plugin = plugin;
        this.disassembleMIPS16 = disassembleMIPS16;
        HelpLocation location = new HelpLocation("DisassemblerPlugin", "Disassemble");
        this.setHelpLocation(location);
        this.setPopupMenuData(new MenuData(new String[]{"Disassemble - MIPS"}, null, groupName));
        int keyEvent = disassembleMIPS16 ? 123 : 122;
        this.setKeyBindingData(new KeyBindingData(keyEvent, 0));
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        this.plugin.disassembleMipsCallback(context, this.disassembleMIPS16);
    }

    @Override
    protected boolean isAddToPopup(ListingActionContext context) {
        if (!this.isEnabledForContext(context)) {
            return false;
        }
        String alternateMips = null;
        String langName = context.getProgram().getLanguage().getLanguageDescription().getLanguageID().getIdAsString();
        alternateMips = langName.contains("micro") || langName.contains("R6") ? "MicroMips" : "Mips16e";
        this.setPopupMenuData(new MenuData(new String[]{"Disassemble - " + (this.disassembleMIPS16 ? alternateMips : "MIPS")}, null, this.groupName));
        return true;
    }

    @Override
    public boolean isEnabledForContext(ListingActionContext context) {
        Address address = context.getAddress();
        if (address == null) {
            return false;
        }
        Program program = context.getProgram();
        Language lang = program.getLanguage();
        Processor proc = lang.getProcessor();
        if (!"MIPS".equals(proc.toString())) {
            return false;
        }
        Register register = context.getProgram().getProgramContext().getRegister("ISA_MODE");
        if (register == null) {
            return false;
        }
        return this.plugin.checkDisassemblyEnabled(context, address, true);
    }
}

