/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.disassembler;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.disassembler.DisassemblerPlugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;

class PowerPCDisassembleAction
extends ListingContextAction {
    private DisassemblerPlugin plugin;
    private boolean disassemblePPC = false;
    String groupName;

    public PowerPCDisassembleAction(DisassemblerPlugin plugin, String groupName, boolean disassemblePPC) {
        super("Disassemble " + (disassemblePPC ? "PPC-VLE" : "PPC"), plugin.getName());
        this.groupName = groupName;
        this.plugin = plugin;
        this.disassemblePPC = disassemblePPC;
        HelpLocation location = new HelpLocation("DisassemblerPlugin", "Disassemble");
        this.setHelpLocation(location);
        this.initializeContextMenu();
        int keyEvent = disassemblePPC ? 123 : 122;
        this.setKeyBindingData(new KeyBindingData(keyEvent, 0));
    }

    public void initializeContextMenu() {
        this.setPopupMenuData(new MenuData(new String[]{"Disassemble - " + (this.disassemblePPC ? "PPC-VLE" : "PPC")}, null, this.groupName));
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        this.plugin.disassemblePPCCallback(context, this.disassemblePPC);
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        Address address = context.getAddress();
        if (address == null) {
            return false;
        }
        Program program = context.getProgram();
        Language lang = program.getLanguage();
        Processor proc = lang.getProcessor();
        if (!proc.equals((Object)Processor.findOrPossiblyCreateProcessor((String)"PowerPC")) || lang.getLanguageID().toString().indexOf(":VLE") < 0) {
            return false;
        }
        return this.plugin.checkDisassemblyEnabled(context, address, true);
    }
}

