/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.framework.plugintool.PluginTool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

abstract class CommentDialog
extends DialogComponentProvider {
    private JTextArea commentsField;
    private boolean applyWasDone;
    private String origComments;
    protected FunctionPlugin plugin;

    CommentDialog(FunctionPlugin plugin) {
        super("Set Comment");
        this.addWorkPanel(this.createPanel());
        this.addListeners();
        this.addOKButton();
        this.addApplyButton();
        this.addCancelButton();
        this.plugin = plugin;
    }

    void showDialog(String comment) {
        this.applyWasDone = true;
        this.origComments = comment;
        this.commentsField.setText(this.origComments);
        if (this.origComments != null && this.origComments.length() > 0) {
            this.commentsField.selectAll();
        }
        PluginTool tool = this.plugin.getTool();
        tool.showDialog((DialogComponentProvider)this, tool.getComponentProvider("CodeBrowserPlugin"));
    }

    protected void cancelCallback() {
        this.close();
    }

    protected void okCallback() {
        this.applyCallback();
        this.close();
    }

    protected void applyCallback() {
        if (!this.applyWasDone) {
            this.origComments = this.commentsField.getText();
            this.doApply(this.origComments);
            this.applyWasDone = true;
        }
    }

    protected abstract void doApply(String var1);

    private JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel p = new JPanel();
        this.commentsField = new JTextArea(10, 50);
        this.commentsField.setLineWrap(true);
        this.commentsField.setWrapStyleWord(true);
        JScrollPane scrollP = new JScrollPane(this.commentsField);
        p.add(scrollP);
        panel.add((Component)scrollP, "Center");
        return panel;
    }

    private void addListeners() {
        this.commentsField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                CommentDialog.this.applyWasDone = false;
            }
        });
    }
}

