/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.actions.AbstractFindReferencesDataTypeAction;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.navigation.locationreferences.AddressLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.DataTypeLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferencesPlugin;
import ghidra.app.plugin.core.navigation.locationreferences.StructureMemberLocationDescriptor;
import ghidra.framework.options.DummyKeyBindingsOptionsAction;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.util.ProgramLocation;
import javax.swing.KeyStroke;

public class FindReferencesToAction
extends ListingContextAction
implements OptionsChangeListener {
    private LocationReferencesPlugin plugin;
    private int subGroupPosition;

    public FindReferencesToAction(LocationReferencesPlugin plugin, int subGroupPosition) {
        super("Find References To", plugin.getName(), false);
        this.plugin = plugin;
        this.subGroupPosition = subGroupPosition;
        this.updateMenuName(null);
        this.setDescription("Shows references to the item under the cursor");
        KeyStroke defaultkeyStroke = AbstractFindReferencesDataTypeAction.DEFAULT_KEY_STROKE;
        PluginTool tool = plugin.getTool();
        DummyKeyBindingsOptionsAction action = new DummyKeyBindingsOptionsAction("Find References To", defaultkeyStroke);
        tool.addAction((DockingActionIf)action);
        ToolOptions options = tool.getOptions("Key Bindings");
        KeyStroke optionsKeyStroke = options.getKeyStroke(action.getFullName(), defaultkeyStroke);
        if (!defaultkeyStroke.equals(optionsKeyStroke)) {
            this.setUnvalidatedKeyBindingData(new KeyBindingData(optionsKeyStroke));
        } else {
            this.setKeyBindingData(new KeyBindingData(optionsKeyStroke));
        }
        options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    public void optionsChanged(ToolOptions options, String name, Object oldValue, Object newValue) {
        KeyStroke keyStroke = (KeyStroke)newValue;
        String actionName = this.getName();
        if (name.startsWith(actionName)) {
            this.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        }
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        this.plugin.displayProvider(context);
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        LocationDescriptor descriptor = this.getDescriptor(context);
        if (descriptor == null) {
            return false;
        }
        this.updateMenuName(descriptor);
        return true;
    }

    private LocationDescriptor getDescriptor(ListingActionContext context) {
        ProgramLocation location = context.getLocation();
        if (location.getAddress() == null && location.getComponentPath() == null) {
            return null;
        }
        LocationDescriptor descriptor = this.plugin.getLocationDescriptor(location);
        return descriptor;
    }

    @Override
    protected boolean isAddToPopup(ListingActionContext context) {
        if (!super.isAddToPopup(context)) {
            return false;
        }
        LocationDescriptor descriptor = this.getDescriptor(context);
        if (descriptor == null) {
            return false;
        }
        if (!(descriptor instanceof AddressLocationDescriptor)) {
            return true;
        }
        AddressLocationDescriptor addressDescriptor = (AddressLocationDescriptor)descriptor;
        Address homeAddress = addressDescriptor.getHomeAddress();
        Address actionAddress = context.getAddress();
        return !actionAddress.equals((Object)homeAddress);
    }

    private void updateMenuName(LocationDescriptor descriptor) {
        Object menuName = this.getMenuPrefix(descriptor);
        if (descriptor != null) {
            String itemName = descriptor.getTypeName();
            menuName = (String)menuName + itemName;
        }
        this.setPopupMenuData(new MenuData(new String[]{"References", menuName}, null, "ShowReferencesTo", -1, Integer.toString(this.subGroupPosition)));
    }

    private String getMenuPrefix(LocationDescriptor descriptor) {
        String menuName = "Show References to ";
        if (descriptor == null) {
            return menuName;
        }
        if (descriptor instanceof DataTypeLocationDescriptor) {
            menuName = "Find Uses of ";
        }
        if (descriptor instanceof StructureMemberLocationDescriptor) {
            menuName = "Find References to ";
        }
        return menuName;
    }
}

