/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.script;

import generic.jar.ResourceFile;
import ghidra.app.script.GhidraScript;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.app.script.GhidraState;
import ghidra.app.script.ScriptInfo;
import ghidra.app.services.ConsoleService;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Iterator;

class RunScriptTask
extends Task {
    private ResourceFile scriptSourceFile;
    private ConsoleService console;
    private GhidraState currentState;
    private String scriptName;
    private GhidraScript script;

    RunScriptTask(ResourceFile scriptSourceFile, GhidraScript script, GhidraState currentState, ConsoleService console) {
        super(scriptSourceFile.getName(), true, false, false);
        this.scriptSourceFile = scriptSourceFile;
        this.script = script;
        this.scriptName = scriptSourceFile.getName();
        this.console = console;
        this.currentState = currentState;
    }

    public void run(TaskMonitor monitor) {
        block4: {
            if (this.scriptHasNameCollision()) {
                return;
            }
            try {
                Thread.currentThread().setName(this.scriptName);
                this.console.addMessage(this.scriptName, "Running...");
                this.script.execute(this.currentState, monitor, this.console.getStdOut());
                this.console.addMessage(this.scriptName, "Finished!");
            }
            catch (CancelledException e) {
                this.console.addErrorMessage(this.scriptName, "User cancelled script.");
            }
            catch (Exception e) {
                if (monitor.isCancelled()) break block4;
                Msg.showError((Object)((Object)this), null, (String)this.getTaskTitle(), (Object)("Error running script: " + this.scriptName + "\n" + e.getClass().getName() + ": " + e.getMessage()), (Throwable)e);
                this.console.addErrorMessage("", "Error running script: " + this.scriptName);
                this.console.addException(this.scriptName, e);
            }
        }
    }

    private boolean scriptHasNameCollision() {
        if (this.checkDuplicate()) {
            Msg.showWarn((Object)((Object)this), null, (String)"Duplicated Script", (Object)("Unable to run script '" + this.scriptName + "'. Name is not unique (see log for detailed script locations)."));
            return true;
        }
        return false;
    }

    private boolean checkDuplicate() {
        ScriptInfo thisInfo = GhidraScriptUtil.getScriptInfo(this.scriptSourceFile);
        thisInfo.setDuplicate(false);
        ArrayList<ScriptInfo> duplicateScripts = new ArrayList<ScriptInfo>();
        Iterator<ScriptInfo> iter = GhidraScriptUtil.getScriptInfoIterator();
        while (iter.hasNext()) {
            ScriptInfo otherInfo = iter.next();
            if (thisInfo.equals(otherInfo) || !thisInfo.getName().equals(otherInfo.getName())) continue;
            thisInfo.setDuplicate(true);
            otherInfo.setDuplicate(true);
            duplicateScripts.add(otherInfo);
        }
        boolean isDuplicate = thisInfo.isDuplicate();
        if (isDuplicate) {
            Msg.warn((Object)((Object)this), (Object)"Found multiple scripts with the same name: ");
            Msg.warn((Object)((Object)this), (Object)("\t" + thisInfo.getSourceFile().toString()));
            for (ScriptInfo scriptInfo : duplicateScripts) {
                Msg.warn((Object)((Object)this), (Object)("\t" + scriptInfo.getSourceFile().getAbsolutePath()));
            }
        }
        return isDuplicate;
    }

    public Program getProgram() {
        return this.script.getCurrentProgram();
    }
}

