/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug;

import docking.DialogComponentProvider;
import ghidra.app.plugin.debug.MemoryUsagePlugin;
import ghidra.util.layout.PairLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

class ShowMemoryDialog
extends DialogComponentProvider {
    private MemoryUsagePlugin plugin;
    private JLabel maxMem;
    private JLabel totalMem;
    private JLabel freeMem;
    private JLabel usedMem;
    private Timer timer;

    ShowMemoryDialog(MemoryUsagePlugin plugin) {
        super("VM Memory Usage", false, false, true, false);
        this.plugin = plugin;
        this.addOKButton();
        this.setOkButtonText("GC");
        this.addWorkPanel(this.createWorkPanel());
        plugin.getTool().showDialog((DialogComponentProvider)this);
        final DecimalFormat df = new DecimalFormat();
        this.timer = new Timer(2000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Runtime runtime = Runtime.getRuntime();
                ShowMemoryDialog.this.maxMem.setText(df.format(runtime.maxMemory() / 1000L) + "K");
                ShowMemoryDialog.this.totalMem.setText(df.format(runtime.totalMemory() / 1000L) + "K");
                ShowMemoryDialog.this.freeMem.setText(df.format(runtime.freeMemory() / 1000L) + "K");
                ShowMemoryDialog.this.usedMem.setText(df.format((runtime.totalMemory() - runtime.freeMemory()) / 1000L) + "K");
            }
        });
        this.timer.start();
    }

    boolean isInitialized() {
        String text = this.maxMem.getText();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if ('0' == c) continue;
            return true;
        }
        return false;
    }

    protected void cancelCallback() {
        this.timer.stop();
        this.plugin.clearDialog();
        super.cancelCallback();
    }

    protected void okCallback() {
        Runtime.getRuntime().gc();
    }

    private JComponent createWorkPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.maxMem = new JLabel("00000000000", 4);
        this.totalMem = new JLabel("00000000000", 4);
        this.freeMem = new JLabel("00000000000", 4);
        this.usedMem = new JLabel("00000000000", 4);
        panel.add(new JLabel("Max Memory:"));
        panel.add(this.maxMem);
        panel.add(new JLabel("Total Memory:"));
        panel.add(this.totalMem);
        panel.add(new JLabel("Free Memory:"));
        panel.add(this.freeMem);
        panel.add(new JLabel("Used Memory:"));
        panel.add(this.usedMem);
        return panel;
    }
}

