/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import generic.jar.ResourceFile;
import ghidra.app.util.opinion.LibrarySymbolTable;
import ghidra.framework.Application;
import ghidra.framework.options.Options;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.datastruct.FixedSizeHashMap;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LibraryLookupTable {
    private static final int MAX_CACHE_ITEMS = 10;
    private static Map<String, LibrarySymbolTable> cacheMap = new FixedSizeHashMap(10, 10);
    private static List<ResourceFile> filesToDeleteList = new ArrayList<ResourceFile>();

    private static String getMemorySizePath(int size) {
        return size <= 32 ? "win32" : "win64";
    }

    private static ResourceFile createUserResourceDir(int size) {
        File symbols = new File(Application.getUserSettingsDirectory(), "symbols");
        if (!(symbols.exists() && symbols.isDirectory() || symbols.mkdir())) {
            Msg.error(LibraryLookupTable.class, (Object)"couldn't create symbols directory in user's home directory");
            return null;
        }
        File win = new File(symbols, LibraryLookupTable.getMemorySizePath(size));
        if (!(win.exists() && win.isDirectory() || win.mkdir())) {
            Msg.error(LibraryLookupTable.class, (Object)"couldn't create symbols/win directory in user's home directory");
            return null;
        }
        return new ResourceFile(win);
    }

    private static ResourceFile getSystemResourceDir(int size) {
        try {
            return Application.getModuleDataSubDirectory((String)("symbols/" + LibraryLookupTable.getMemorySizePath(size)));
        }
        catch (Exception e) {
            Msg.error(LibraryLookupTable.class, (Object)"couldn't find symbols/win directory in module data directory", (Throwable)e);
            return null;
        }
    }

    static synchronized void getFiles(String dllname, int size, Set<String> unresolvedLibs, Set<String> resolvedLibs) {
        LibrarySymbolTable table;
        if (unresolvedLibs.contains(dllname) || resolvedLibs.contains(dllname)) {
            return;
        }
        ResourceFile file = LibraryLookupTable.getExistingExportsFile(dllname, size);
        if (file == null) {
            unresolvedLibs.add(dllname);
            return;
        }
        long lastExport = file.lastModified();
        ResourceFile defFile = LibraryLookupTable.getExistingOrdinalFile(dllname, size);
        long lastDef = defFile.lastModified();
        if (lastDef > lastExport) {
            unresolvedLibs.add(dllname);
        }
        if ((table = LibraryLookupTable.getSymbolTable(dllname, size)) == null) {
            unresolvedLibs.add(dllname);
            return;
        }
        resolvedLibs.add(dllname);
        List<String> forwards = table.getForwards();
        for (String forward : forwards) {
            LibraryLookupTable.getFiles(forward, size, unresolvedLibs, resolvedLibs);
        }
    }

    static synchronized void cleanup() {
        for (ResourceFile file : filesToDeleteList) {
            file.delete();
        }
        filesToDeleteList.clear();
    }

    public static synchronized ResourceFile createFile(Program program, boolean overwrite, TaskMonitor monitor) throws IOException {
        return LibraryLookupTable.createFile(program, overwrite, false, monitor);
    }

    public static synchronized ResourceFile createFile(Program program, boolean overwrite, boolean inSystem, TaskMonitor monitor) throws IOException {
        boolean save;
        ResourceFile file = null;
        int size = program.getLanguage().getLanguageDescription().getSize();
        file = inSystem ? LibraryLookupTable.getNewSystemExportsFile(new File(program.getExecutablePath()).getName(), size) : LibraryLookupTable.getNewExportsFile(program.getName(), size);
        if (file.exists() && !overwrite) {
            return file;
        }
        monitor.setMessage(program.getName() + ": creating symbol file...");
        LibrarySymbolTable symTab = new LibrarySymbolTable(program, monitor);
        cacheMap.put(symTab.getCacheKey(), symTab);
        Options props = program.getOptions("Program Information");
        String company = props.getString("CompanyName", "");
        String version = props.getString("FileVersion", "");
        boolean bl = save = company != null && company.toLowerCase().indexOf("microsoft") >= 0;
        if (!save) {
            filesToDeleteList.add(file);
        } else {
            symTab.setVersion(version);
        }
        ResourceFile existingDefFile = LibraryLookupTable.getExistingOrdinalFile(program.getName(), size);
        if (existingDefFile != null) {
            symTab.applyOrdinalFile(existingDefFile, false);
        }
        if (!monitor.isCancelled()) {
            File f = file.getFile(true);
            if (f == null) {
                Msg.warn(LibraryLookupTable.class, (Object)"Can't write to installation directory");
            } else {
                symTab.write(f, new File(program.getExecutablePath()), version);
            }
        }
        return file;
    }

    static synchronized LibrarySymbolTable getSymbolTable(String dllName, int size) {
        ResourceFile existingOrdinalFile;
        String cacheKey = LibrarySymbolTable.getCacheKey(dllName, size);
        LibrarySymbolTable symTab = cacheMap.get(cacheKey);
        if (symTab != null) {
            return symTab;
        }
        ResourceFile file = LibraryLookupTable.getExistingExportsFile(dllName, size);
        if (file != null) {
            try {
                symTab = new LibrarySymbolTable(file, size);
                cacheMap.put(symTab.getCacheKey(), symTab);
                return symTab;
            }
            catch (IOException e) {
                Msg.error(LibraryLookupTable.class, (Object)("Error reading " + file + ": " + e.getMessage()), (Throwable)e);
            }
        }
        if ((existingOrdinalFile = LibraryLookupTable.getExistingOrdinalFile(dllName, size)) != null) {
            symTab = new LibrarySymbolTable(dllName, size);
            symTab.applyOrdinalFile(existingOrdinalFile, true);
            cacheMap.put(symTab.getCacheKey(), symTab);
            return symTab;
        }
        return null;
    }

    static synchronized boolean libraryLookupTableFileExists(String dllname, int size) {
        return LibraryLookupTable.getExistingExportsFile(dllname, size) != null;
    }

    static synchronized ResourceFile getExistingExportsFile(String dllName, int size) {
        return LibraryLookupTable.getExistingExtensionedFile(dllName, ".exports", size);
    }

    static synchronized ResourceFile getNewExportsFile(String dllName, int size) {
        return LibraryLookupTable.getNewExtensionedFile(dllName, ".exports", size);
    }

    private static ResourceFile getNewSystemExportsFile(String name, int size) {
        return LibraryLookupTable.getNewSystemExtensionedFile(name, ".exports", size);
    }

    static synchronized ResourceFile getExistingOrdinalFile(String dllName, int size) {
        return LibraryLookupTable.getExistingExtensionedFile(dllName, ".ord", size);
    }

    static synchronized boolean hasFileAndPathAndTimeStampMatch(File libraryFile, int size) {
        try {
            return LibrarySymbolTable.hasFileAndPathAndTimeStampMatch(LibraryLookupTable.getExistingExportsFile(libraryFile.getName(), size), libraryFile);
        }
        catch (Exception e) {
            Msg.debug(LibraryLookupTable.class, (Object)"got exception looking for .exports file (or parsing, etc.)");
            return false;
        }
    }

    static String stripPossibleExtensionFromFilename(String filename) {
        int dotPos = filename.lastIndexOf(46);
        if (dotPos > 0) {
            filename = filename.substring(0, dotPos).toLowerCase();
        }
        return filename;
    }

    static synchronized ResourceFile getExtensionedFile(ResourceFile baseDir, String dllName, String extension) {
        return new ResourceFile(baseDir, dllName + extension);
    }

    static synchronized ResourceFile getStrippedExtensionedFile(ResourceFile baseDir, String dllName, String extension) {
        String stripName = LibraryLookupTable.stripPossibleExtensionFromFilename(dllName).toLowerCase();
        return new ResourceFile(baseDir, stripName + extension);
    }

    static synchronized ResourceFile getExistingExtensionedFile(String dllName, String extension, int size) {
        String currFileName;
        String strippedExtensionFilename = LibraryLookupTable.stripPossibleExtensionFromFilename(dllName).toLowerCase() + extension;
        String extensionFilename = dllName.toLowerCase() + extension;
        ResourceFile[] userFiles = LibraryLookupTable.createUserResourceDir(size).listFiles();
        ResourceFile[] systemFiles = LibraryLookupTable.getSystemResourceDir(size).listFiles();
        for (ResourceFile currFile : userFiles) {
            currFileName = currFile.getName();
            if (!currFileName.equalsIgnoreCase(strippedExtensionFilename) && !currFileName.equalsIgnoreCase(extensionFilename)) continue;
            return currFile;
        }
        for (ResourceFile currFile : systemFiles) {
            currFileName = currFile.getName();
            if (!currFileName.equalsIgnoreCase(strippedExtensionFilename) && !currFileName.equalsIgnoreCase(extensionFilename)) continue;
            return currFile;
        }
        return null;
    }

    static synchronized ResourceFile getNewExtensionedFile(String dllName, String extension, int size) {
        return LibraryLookupTable.getStrippedExtensionedFile(LibraryLookupTable.createUserResourceDir(size), dllName, extension);
    }

    static synchronized ResourceFile getNewSystemExtensionedFile(String dllName, String extension, int size) {
        return LibraryLookupTable.getStrippedExtensionedFile(LibraryLookupTable.getSystemResourceDir(size), dllName, extension);
    }
}

