/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MemoryConflictHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractLibrarySupportLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;

public class MapLoader
extends AbstractLibrarySupportLoader {
    public static final String MAP_NAME = "Program Mapfile (MAP)";
    public static final String NO_MAGIC = "0";

    private List<MapExport> parseExports(ByteProvider provider) throws IOException {
        ArrayList<MapExport> list = new ArrayList<MapExport>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(provider.getInputStream(0L)));){
            String line;
            boolean hasExports = false;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(";")) continue;
                if (line.indexOf("Publics by Value") != -1) {
                    hasExports = true;
                    continue;
                }
                if (!hasExports) continue;
                MapExport exp = new MapExport(line);
                list.add(exp);
            }
        }
        return list;
    }

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (provider.getName() != null && provider.getName().toLowerCase().endsWith(".map") && !this.parseExports(provider).isEmpty()) {
            List<QueryResult> results = QueryOpinionService.query(this.getName(), NO_MAGIC, null);
            for (QueryResult result : results) {
                loadSpecs.add(new LoadSpec((Loader)this, 0L, result));
            }
            if (loadSpecs.isEmpty()) {
                loadSpecs.add(new LoadSpec((Loader)this, 0L, true));
            }
        }
        return loadSpecs;
    }

    @Override
    public void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program prog, MemoryConflictHandler handler, TaskMonitor monitor, MessageLog log) throws IOException {
        if (!prog.getExecutableFormat().equals("Portable Executable (PE)")) {
            throw new IOException("Program must be a Portable Executable (PE)");
        }
        SymbolTable symtab = prog.getSymbolTable();
        for (MapExport exp : this.parseExports(provider)) {
            long addr = (long)exp.addr & 0xFFFFFFFFL;
            Address address = prog.getAddressFactory().getDefaultAddressSpace().getAddress(addr);
            try {
                Symbol name = symtab.createLabel(address, exp.name, SourceType.IMPORTED);
                name.setPrimary();
            }
            catch (InvalidInputException e) {
                log.appendMsg(e.getMessage());
            }
        }
    }

    @Override
    public String getName() {
        return MAP_NAME;
    }

    private class MapExport {
        String offset;
        String name;
        int addr;
        String type;

        MapExport(String exportLine) {
            StringTokenizer nizer = new StringTokenizer(exportLine, " ");
            this.offset = nizer.nextToken();
            this.name = nizer.nextToken();
            this.addr = Integer.parseInt(nizer.nextToken());
            this.type = nizer.nextToken();
        }
    }
}

