/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ComponentPlaceholder;
import docking.ComponentTransferable;
import docking.ComponentTransferableData;
import docking.DockableComponent;
import docking.DockableToolBarManager;
import docking.DockingWindowManager;
import docking.GenericHeader;
import docking.SplitPanel;
import docking.WindowPosition;
import docking.help.Help;
import docking.help.HelpService;
import docking.util.AnimationUtils;
import generic.util.WindowUtilities;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.bean.GGlassPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FocusTraversalPolicy;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jdesktop.animation.timing.Animator;

public class DockableHeader
extends GenericHeader
implements DragGestureListener,
DragSourceListener {
    private DockableComponent dockComp;
    private static Cursor leftCursor;
    private static Cursor rightCursor;
    private static Cursor topCursor;
    private static Cursor bottomCursor;
    private static Cursor stackCursor;
    private static Cursor newWindowCursor;
    private static Cursor noDropCursor;
    private DragCursorManager dragCursorManager = this.createDragCursorManager();
    private DragSource dragSource = null;
    private boolean isDocking;
    private Animator focusAnimator;
    private int focusToggle = -1;

    DockableHeader(DockableComponent dockableComp, boolean isDocking) {
        this.dockComp = dockableComp;
        this.isDocking = isDocking;
        this.setComponent(dockableComp);
        this.dragSource = new DragSource();
        ComponentPlaceholder info = dockableComp.getComponentWindowingPlaceholder();
        this.setTitle(info.getFullTitle());
        this.setIcon(info.getIcon());
        this.toolBarMgr = new DockableToolBarManager(dockableComp, this);
        this.dragSource.createDefaultDragGestureRecognizer(this.titlePanel.getDragComponent(), 2, this);
        this.resetComponents();
    }

    @Override
    public void requestFocus() {
        this.validateFocusability();
        this.dockComp.requestFocus();
    }

    @Override
    public void setSelected(boolean hasFocus) {
        if (!hasFocus && this.focusAnimator != null) {
            this.focusAnimator.stop();
            this.focusAnimator = null;
        }
        super.setSelected(hasFocus);
    }

    void installRenameAction(MouseListener listener) {
        this.titlePanel.installRenameAction(listener);
    }

    void setHelp(HelpLocation location) {
        HelpService service = Help.getHelpService();
        if (location == null) {
            service.clearHelp(this.titlePanel);
        } else {
            service.registerHelp(this.titlePanel, location);
        }
    }

    void emphasize() {
        DockingWindowManager manager = DockingWindowManager.getInstance(this);
        if (manager == null) {
            return;
        }
        JFrame toolFrame = manager.getRootFrame();
        Component glassPane = toolFrame.getGlassPane();
        if (!(glassPane instanceof GGlassPane)) {
            return;
        }
        if (this.focusAnimator != null && this.focusAnimator.isRunning()) {
            return;
        }
        this.focusAnimator = this.createEmphasizingAnimator(toolFrame);
    }

    protected Animator createEmphasizingAnimator(JFrame parentFrame) {
        ++this.focusToggle;
        switch (this.focusToggle) {
            case 0: {
                return AnimationUtils.shakeComponent(this.component);
            }
            case 1: {
                return AnimationUtils.rotateComponent(this.component);
            }
            case 2: {
                return this.raiseComponent(parentFrame);
            }
        }
        this.focusToggle = -1;
        return AnimationUtils.pulseComponent(this.component);
    }

    private Animator raiseComponent(JFrame parent) {
        if (this.isOnlyComponentInParent(parent)) {
            return super.createEmphasizingAnimator();
        }
        return AnimationUtils.focusComponent(this.component);
    }

    private boolean isOnlyComponentInParent(JFrame parentFrame) {
        return !this.isInSplitPanel();
    }

    private boolean isInSplitPanel() {
        Container parent;
        for (parent = this.component.getParent(); parent != null && !(parent instanceof SplitPanel); parent = parent.getParent()) {
        }
        return parent instanceof SplitPanel;
    }

    private void validateFocusability() {
        Container focusCycleRootAncestor = this.dockComp.getFocusCycleRootAncestor();
        FocusTraversalPolicy policy = focusCycleRootAncestor.getFocusTraversalPolicy();
        Component firstComponent = policy.getFirstComponent(this.dockComp);
        if (firstComponent == null) {
            ComponentPlaceholder info = this.dockComp.getComponentWindowingPlaceholder();
            Msg.debug((Object)this, (Object)("Found a ComponentProvider that does not contain a focusable component: " + info.getTitle() + ".  ComponentProviders are required to have at least one focusable component!"));
            this.setSelected(false);
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        if (!this.isDocking) {
            return;
        }
        InputEvent ie = event.getTriggerEvent();
        int modifiers = ie.getModifiers();
        if ((modifiers & 8) != 0 || (modifiers & 4) != 0) {
            return;
        }
        DockableComponent.DROP_CODE = DockableComponent.DropCode.WINDOW;
        DockableComponent.DROP_CODE_SET = true;
        DockableComponent.SOURCE_INFO = this.dockComp.getComponentWindowingPlaceholder();
        this.dragCursorManager.dragStarted();
        this.dragSource.startDrag(event, DragSource.DefaultMoveNoDrop, new ComponentTransferable(new ComponentTransferableData(this.dockComp)), this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent event) {
        this.dragCursorManager.restoreCursorOnPreviousDraggedOverComponent();
        this.dragCursorManager.dragEnded();
        ComponentPlaceholder info = this.dockComp.getComponentWindowingPlaceholder();
        DockingWindowManager winMgr = info.getNode().winMgr;
        if (DockableComponent.DROP_CODE == DockableComponent.DropCode.INVALID) {
            return;
        }
        if (DockableComponent.DROP_CODE == DockableComponent.DropCode.WINDOW) {
            winMgr.movePlaceholder(info, event.getLocation());
        } else {
            winMgr.movePlaceholder(info, DockableComponent.TARGET_INFO, this.getWindowPosition());
        }
    }

    private WindowPosition getWindowPosition() {
        switch (DockableComponent.DROP_CODE) {
            case BOTTOM: {
                return WindowPosition.BOTTOM;
            }
            case LEFT: {
                return WindowPosition.LEFT;
            }
            case RIGHT: {
                return WindowPosition.RIGHT;
            }
            case STACK: {
                return WindowPosition.STACK;
            }
            case TOP: {
                return WindowPosition.TOP;
            }
        }
        return WindowPosition.STACK;
    }

    @Override
    public void dragEnter(DragSourceDragEvent event) {
        this.setCursor(event);
    }

    @Override
    public void dragExit(DragSourceEvent event) {
        this.setCursor(event);
    }

    @Override
    public void dragOver(DragSourceDragEvent event) {
        this.setCursor(event);
    }

    private void setCursor(DragSourceEvent event) {
        DockableComponent.DROP_CODE_SET = false;
        Cursor c = noDropCursor;
        switch (DockableComponent.DROP_CODE) {
            case LEFT: {
                c = leftCursor;
                break;
            }
            case RIGHT: {
                c = rightCursor;
                break;
            }
            case TOP: {
                c = topCursor;
                break;
            }
            case BOTTOM: {
                c = bottomCursor;
                break;
            }
            case STACK: {
                c = stackCursor;
                break;
            }
            case ROOT: {
                c = stackCursor;
                break;
            }
            case WINDOW: {
                c = newWindowCursor;
                break;
            }
        }
        this.dragCursorManager.setCursor(event, c);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent event) {
    }

    private DragCursorManager createDragCursorManager() {
        if (Platform.CURRENT_PLATFORM.getOperatingSystem() == OperatingSystem.MAC_OS_X) {
            return new MacDragCursorManager();
        }
        return new DragCursorManager();
    }

    private static void drawLeftArrow(BufferedImage image) {
        int j;
        int i;
        int v = -16777216;
        int y = 6;
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 2 * i + 1; ++j) {
                image.setRGB(i, y - i + j, v);
            }
        }
        for (i = 6; i < 12; ++i) {
            for (j = 0; j < 3; ++j) {
                image.setRGB(i, y - 1 + j, v);
            }
        }
    }

    private static void drawRightArrow(BufferedImage image) {
        int j;
        int i;
        int v = -16777216;
        int y = 6;
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 2 * i + 1; ++j) {
                image.setRGB(31 - i, y - i + j, v);
            }
        }
        for (i = 6; i < 12; ++i) {
            for (j = 0; j < 3; ++j) {
                image.setRGB(31 - i, y - 1 + j, v);
            }
        }
    }

    private static void drawTopArrow(BufferedImage image) {
        int j;
        int i;
        int v = -16777216;
        int x = 6;
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 2 * i + 1; ++j) {
                image.setRGB(x - i + j, i, v);
            }
        }
        for (i = 6; i < 12; ++i) {
            for (j = 0; j < 3; ++j) {
                image.setRGB(x - 1 + j, i, v);
            }
        }
    }

    private static void drawBottomArrow(BufferedImage image) {
        int j;
        int i;
        int v = -16777216;
        int x = 6;
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 2 * i + 1; ++j) {
                image.setRGB(x - i + j, 31 - i, v);
            }
        }
        for (i = 6; i < 12; ++i) {
            for (j = 0; j < 3; ++j) {
                image.setRGB(x - 1 + j, 31 - i, v);
            }
        }
    }

    private static void drawStack(BufferedImage image) {
        int v = -16777216;
        for (int i = 0; i < 3; ++i) {
            int x = i * 3;
            int y = 6 - i * 3;
            for (int j = 0; j < 10; ++j) {
                image.setRGB(x, y + j, v);
                image.setRGB(x + 10, y + j, v);
                image.setRGB(x + j, y, v);
                image.setRGB(x + j, y + 10, v);
            }
        }
    }

    private static void drawNewWindow(BufferedImage image) {
        int i;
        int v = -16777216;
        for (i = 0; i < 5; ++i) {
            for (int j = 0; j < 14; ++j) {
                image.setRGB(j, i, -16776961);
            }
        }
        for (i = 0; i < 14; ++i) {
            image.setRGB(i, 0, v);
            image.setRGB(i, 10, v);
        }
        for (i = 0; i < 10; ++i) {
            image.setRGB(0, i, v);
            image.setRGB(14, i, v);
        }
    }

    static {
        noDropCursor = DragSource.DefaultMoveNoDrop;
        Toolkit tk = Toolkit.getDefaultToolkit();
        BufferedImage image = new BufferedImage(32, 32, 2);
        DockableHeader.drawLeftArrow(image);
        leftCursor = tk.createCustomCursor(image, new Point(0, 6), "LEFT");
        image = new BufferedImage(32, 32, 2);
        DockableHeader.drawRightArrow(image);
        rightCursor = tk.createCustomCursor(image, new Point(31, 6), "RIGHT");
        image = new BufferedImage(32, 32, 2);
        DockableHeader.drawTopArrow(image);
        topCursor = tk.createCustomCursor(image, new Point(6, 0), "TOP");
        image = new BufferedImage(32, 32, 2);
        DockableHeader.drawBottomArrow(image);
        bottomCursor = tk.createCustomCursor(image, new Point(6, 31), "BOTTOM");
        image = new BufferedImage(32, 32, 2);
        DockableHeader.drawStack(image);
        stackCursor = tk.createCustomCursor(image, new Point(8, 8), "STACK");
        image = new BufferedImage(32, 32, 2);
        DockableHeader.drawNewWindow(image);
        newWindowCursor = tk.createCustomCursor(image, new Point(0, 0), "NEW_WINDOW");
    }

    private class MacDragCursorManager
    extends DragCursorManager {
        private Map<Component, Cursor> defaultCursors;
        private Component componentUnderDrag;

        private MacDragCursorManager() {
            this.defaultCursors = new HashMap<Component, Cursor>();
        }

        @Override
        void setCursor(DragSourceEvent event, Cursor dragCursor) {
            Component hoveredComponent;
            ComponentPlaceholder placeholder = DockableComponent.DRAGGED_OVER_INFO;
            Component mousedComponent = null;
            if (placeholder == null) {
                super.setCursor(event, dragCursor);
                return;
            }
            int x = event.getX();
            int y = event.getY();
            Point screenPoint = new Point(x, y);
            DockableComponent draggedOverComponent = placeholder.getComponent();
            SwingUtilities.convertPointFromScreen(screenPoint, draggedOverComponent);
            mousedComponent = hoveredComponent = SwingUtilities.getDeepestComponentAt(draggedOverComponent, screenPoint.x, screenPoint.y);
            if (mousedComponent == null) {
                mousedComponent = placeholder.getComponent();
            }
            if (this.componentUnderDrag != mousedComponent) {
                this.restoreCursorOnPreviousDraggedOverComponent();
            }
            this.componentUnderDrag = mousedComponent;
            mousedComponent.setCursor(dragCursor);
            super.setCursor(event, dragCursor);
        }

        @Override
        void restoreCursorOnPreviousDraggedOverComponent() {
            if (this.componentUnderDrag == null) {
                return;
            }
            Cursor restoreCursor = this.defaultCursors.get(this.componentUnderDrag);
            Window window = WindowUtilities.windowForComponent((Component)this.componentUnderDrag);
            if (window != null) {
                Cursor windowCursor = this.defaultCursors.get(window);
                window.setCursor(windowCursor);
            }
            this.componentUnderDrag.setCursor(restoreCursor);
            this.componentUnderDrag = null;
        }

        @Override
        void dragStarted() {
            Window[] windows;
            this.defaultCursors.clear();
            for (Window window : windows = Window.getWindows()) {
                this.storeCursors(window);
            }
        }

        private void storeCursors(Container c) {
            Component[] children;
            this.defaultCursors.put(c, c.getCursor());
            for (Component child : children = c.getComponents()) {
                if (!(child instanceof Container)) continue;
                this.storeCursors((Container)child);
            }
        }

        @Override
        void dragEnded() {
            this.defaultCursors.clear();
        }
    }

    private class DragCursorManager {
        private DragCursorManager() {
        }

        void setCursor(DragSourceEvent event, Cursor dragCursor) {
            DragSourceContext context = event.getDragSourceContext();
            context.setCursor(dragCursor);
        }

        void dragStarted() {
        }

        void dragEnded() {
        }

        void restoreCursorOnPreviousDraggedOverComponent() {
        }
    }
}

