/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;

public abstract class AbstractGCellRenderer
extends JLabel {
    private static final Color ALTERNATE_BACKGROUND_COLOR = new Color(237, 243, 254);
    private static final String DISABLE_ALTERNATING_ROW_COLORS_PROPERTY = "disable.alternating.row.colors";
    protected static boolean systemAlternateRowColors = AbstractGCellRenderer.getAlternateRowColors();
    protected static final String HTML_DISABLE_STRING = "html.disable";
    protected final Border focusBorder;
    protected final Border noFocusBorder = BorderFactory.createEmptyBorder(0, 5, 0, 5);
    protected Font defaultFont;
    protected Font fixedWidthFont;
    protected Font boldFont;
    protected int dropRow = -1;
    private boolean instanceAlternateRowColors = true;

    private static boolean getAlternateRowColors() {
        String disable = System.getProperty(DISABLE_ALTERNATING_ROW_COLORS_PROPERTY);
        if (disable == null) {
            return true;
        }
        return !Boolean.parseBoolean(disable);
    }

    public AbstractGCellRenderer() {
        Border innerBorder = BorderFactory.createEmptyBorder(0, 4, 0, 4);
        Border outerBorder = BorderFactory.createLineBorder(Color.YELLOW, 1);
        this.focusBorder = BorderFactory.createCompoundBorder(outerBorder, innerBorder);
        this.setBorder(this.noFocusBorder);
        this.setHTMLRenderingEnabled(false);
        this.setShouldAlternateRowBackgroundColors(true);
        this.setOpaque(true);
    }

    public void setHTMLRenderingEnabled(boolean enable) {
        this.putClientProperty(HTML_DISABLE_STRING, !enable);
    }

    public void setShouldAlternateRowBackgroundColors(boolean alternate) {
        this.instanceAlternateRowColors = alternate;
    }

    public boolean shouldAlternateRowBackgroundColor() {
        if (systemAlternateRowColors) {
            return this.instanceAlternateRowColors;
        }
        return false;
    }

    protected Color getOSDependentBackgroundColor(JComponent parent, int row) {
        if (!this.shouldAlternateRowBackgroundColor()) {
            return parent.getBackground();
        }
        return AbstractGCellRenderer.getBackgroundColorForRow(row);
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.defaultFont = f;
        this.fixedWidthFont = new Font("monospaced", this.defaultFont.getStyle(), this.defaultFont.getSize());
        this.boldFont = new Font(this.defaultFont.getName(), 1, this.defaultFont.getSize());
    }

    protected void superSetFont(Font font) {
        super.setFont(font);
    }

    protected void setBold() {
        super.setFont(this.boldFont);
    }

    public void setDropRow(int dropRow) {
        this.dropRow = dropRow;
    }

    protected Border getNoFocusBorder() {
        return this.noFocusBorder;
    }

    protected Font getDefaultFont() {
        return this.defaultFont;
    }

    protected Font getFixedWidthFont() {
        return this.fixedWidthFont;
    }

    protected Font getBoldFont() {
        return this.boldFont;
    }

    protected String getText(Object value) {
        return value == null ? "" : value.toString();
    }

    protected static Color getBackgroundColorForRow(int row) {
        if ((row & 1) == 1) {
            return Color.WHITE;
        }
        return ALTERNATE_BACKGROUND_COLOR;
    }

    @Override
    public void invalidate() {
    }

    protected void superValidate() {
        super.invalidate();
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName.equals("text") || propertyName.equals("labelFor") || propertyName.equals("displayedMnemonic") || (propertyName.equals("font") || propertyName.equals("foreground")) && oldValue != newValue && this.getClientProperty("html") != null) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

