/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.conditiontestpanel;

import docking.widgets.EmptyBorderButton;
import docking.widgets.conditiontestpanel.ConditionResult;
import docking.widgets.conditiontestpanel.ConditionStatus;
import docking.widgets.conditiontestpanel.ConditionTestListener;
import docking.widgets.conditiontestpanel.ConditionTestModel;
import docking.widgets.conditiontestpanel.ConditionTester;
import ghidra.util.HTMLUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.layout.PairLayout;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import resources.ResourceManager;

public class ConditionTestPanel
extends JPanel {
    static final Icon ERROR_ICON = ResourceManager.loadImage((String)"images/edit-delete.png");
    static final Icon WARNING_ICON = ResourceManager.loadImage((String)"images/dialog-warning.png");
    static final Icon PASSED_ICON = ResourceManager.loadImage((String)"images/checkmark_green.gif");
    private ConditionTestModel conditionTestModel;
    private TaskMonitorComponent taskMonitor;
    private List<TestPanel> testPanelList = new ArrayList<TestPanel>();
    private List<TestStatusPanel> testStatusPanelList = new ArrayList<TestStatusPanel>();
    private JLabel runsLabel;
    private JLabel errorsLabel;
    private JLabel warningsLabel;
    private OverallProgressBar overallProgressBar;
    private JLabel detailsLabel;
    private ConditionTester selectedTest;
    final HashSet<ConditionTestListener> listeners = new HashSet();

    public ConditionTestPanel(List<ConditionTester> tests) {
        super(new BorderLayout());
        this.conditionTestModel = new ConditionTestModel(this, tests);
        this.add(this.buildStatusPanel(), "North");
        JSplitPane splitPane = new JSplitPane(0, this.buildTestPanel(), this.buildDetailsPanel());
        this.add((Component)splitPane, "Center");
        splitPane.setResizeWeight(0.75);
        this.taskMonitor = new TaskMonitorComponent();
    }

    public void addListener(ConditionTestListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ConditionTestListener listener) {
        this.listeners.remove(listener);
    }

    public boolean hasRunTests() {
        return this.conditionTestModel.getCompletedTestCount() == this.conditionTestModel.getTestCount();
    }

    public boolean isInProgress() {
        return this.conditionTestModel.isInProgress();
    }

    public int getErrorCount() {
        return this.conditionTestModel.getErrorCount();
    }

    public int getWarningCount() {
        return this.conditionTestModel.getWarningCount();
    }

    public int getSkippedCount() {
        return this.conditionTestModel.getSkippedCount();
    }

    void update() {
        this.updateSummary();
        this.updateOverallProgress();
        this.updateTestStatus();
        this.updateDetailMessage();
    }

    private void updateDetailMessage() {
        if (this.selectedTest == null) {
            this.detailsLabel.setText("");
            return;
        }
        String message = this.conditionTestModel.getStatusMessage(this.selectedTest);
        String htmlString = HTMLUtilities.toHTML((String)message);
        this.detailsLabel.setText(htmlString);
    }

    private void updateTestStatus() {
        for (TestStatusPanel testStatusPanel : this.testStatusPanelList) {
            ConditionTester test = testStatusPanel.getTest();
            ConditionStatus status = this.conditionTestModel.getStatus(test);
            testStatusPanel.setStatus(status);
            testStatusPanel.setInProgress(this.conditionTestModel.isInProgress(test));
        }
    }

    private void updateOverallProgress() {
        this.overallProgressBar.setMaxProgress(this.conditionTestModel.getTestCount());
        this.overallProgressBar.setProgress(this.conditionTestModel.getCompletedTestCount());
        Color color = Color.GREEN;
        if (this.conditionTestModel.getErrorCount() > 0) {
            color = Color.RED;
        } else if (this.conditionTestModel.getWarningCount() > 0) {
            color = Color.YELLOW;
        }
        this.overallProgressBar.setColor(color);
    }

    private void updateSummary() {
        int testCount = this.conditionTestModel.getTestCount();
        int completedTestCount = this.conditionTestModel.getCompletedTestCount();
        this.runsLabel.setText("Tests: " + completedTestCount + "/" + testCount);
        this.warningsLabel.setText("Warnings: " + this.conditionTestModel.getWarningCount());
        this.errorsLabel.setText("Errors: " + this.conditionTestModel.getErrorCount());
    }

    private Component buildDetailsPanel() {
        this.detailsLabel = new ScrollableLabel();
        this.detailsLabel.setVerticalAlignment(1);
        JScrollPane scroll = new JScrollPane(this.detailsLabel);
        return scroll;
    }

    private Component buildTestPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(5, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        List<ConditionTester> tests = this.conditionTestModel.getTests();
        for (ConditionTester conditionTest : tests) {
            TestPanel testPanel = new TestPanel(conditionTest);
            TestStatusPanel statusPanel = new TestStatusPanel(conditionTest);
            this.testPanelList.add(testPanel);
            this.testStatusPanelList.add(statusPanel);
            panel.add(testPanel);
            panel.add(statusPanel);
        }
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        return scrollPane;
    }

    private Component buildStatusPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.createRunAndSummaryPanel(), "West");
        this.overallProgressBar = new OverallProgressBar();
        panel.add(this.overallProgressBar);
        return panel;
    }

    public void runTests() {
        this.conditionTestModel.runTests(this.taskMonitor);
    }

    public void skipTests() {
        for (TestPanel testPanel : this.testPanelList) {
            testPanel.checkbox.setSelected(false);
        }
        this.conditionTestModel.skipTests();
        this.testsCompleted();
    }

    private Component createRunAndSummaryPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        EmptyBorderButton runButton = new EmptyBorderButton(ResourceManager.loadImage((String)"images/play.png"));
        runButton.addActionListener(e -> this.conditionTestModel.runTests(this.taskMonitor));
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 0));
        buttonPanel.add(runButton);
        panel.add((Component)buttonPanel, "West");
        panel.add(this.createSummaryPanel());
        return panel;
    }

    private Component createSummaryPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 3, 20, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.runsLabel = new JLabel("Tests: 0/" + this.conditionTestModel.getTestCount());
        panel.add(this.runsLabel);
        this.errorsLabel = new JLabel("Errors: 0");
        panel.add(this.errorsLabel);
        this.warningsLabel = new JLabel("Warnings: 0");
        panel.add(this.warningsLabel);
        return panel;
    }

    void selectTest(ConditionTester test) {
        this.selectedTest = test;
        for (TestPanel testPanel : this.testPanelList) {
            testPanel.setSelected(test);
        }
        this.updateDetailMessage();
    }

    public void testsCompleted() {
        for (ConditionTestListener listener : this.listeners) {
            listener.testsCompleted();
        }
        this.update();
        ConditionTester bestTestToSelect = null;
        for (TestPanel testPanel : this.testPanelList) {
            ConditionTester test = testPanel.getTest();
            ConditionStatus status = this.conditionTestModel.getStatus(test);
            if (status == ConditionStatus.Error) {
                bestTestToSelect = test;
                break;
            }
            if (status != ConditionStatus.Warning || bestTestToSelect != null) continue;
            bestTestToSelect = test;
        }
        if (bestTestToSelect != null) {
            this.selectTest(bestTestToSelect);
        }
    }

    public void cancel() {
        this.conditionTestModel.cancel();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test App");
        ArrayList<ConditionTester> list = new ArrayList<ConditionTester>();
        list.add(new TestConditionRun("Beta ConfigTest", 20, ConditionStatus.Error, "This is an error This is an error This is an errorThis is an error This is an error And this is another line"));
        list.add(new TestConditionRun("Alpha ConfigTest", 15));
        list.add(new TestConditionRun("Gamma  adfda asdfasdf ConfigTest", 50));
        list.add(new TestConditionRun("Zeta ConfigTest", 30, ConditionStatus.Warning, "This is a warning"));
        list.add(new TestConditionRun("Delta ConfigTest", 20));
        ConditionTestPanel ctPanel = new ConditionTestPanel(list);
        frame.getContentPane().add(ctPanel);
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private static class TestConditionRun
    implements ConditionTester {
        private final int runIterations;
        private final String name;
        private final ConditionStatus result;
        private final String msg;

        public TestConditionRun(String name, int runIterations) {
            this(name, runIterations, ConditionStatus.Passed, null);
        }

        public TestConditionRun(String name, int runIterations, ConditionStatus result, String msg) {
            this.name = name;
            this.runIterations = runIterations;
            this.result = result;
            this.msg = msg;
        }

        @Override
        public String getDescription() {
            return this.name + " description goes here";
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ConditionResult run(TaskMonitor monitor) throws CancelledException {
            monitor.initialize((long)this.runIterations);
            for (int i = 0; i < this.runIterations; ++i) {
                monitor.setProgress((long)i);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                monitor.checkCanceled();
            }
            return new ConditionResult(this.result, this.msg);
        }
    }

    private class TestStatusPanel
    extends JPanel {
        private final ConditionTester test;
        private JLabel label;
        private boolean inProgress;

        public TestStatusPanel(ConditionTester test) {
            super(new BorderLayout());
            this.test = test;
            this.label = new JLabel();
            this.label.setHorizontalAlignment(2);
            this.add(this.label);
        }

        public void setStatus(ConditionStatus status) {
            Icon icon = null;
            switch (status) {
                case Error: {
                    icon = ERROR_ICON;
                    break;
                }
                case Cancelled: {
                    icon = WARNING_ICON;
                    break;
                }
                case Passed: {
                    icon = PASSED_ICON;
                    break;
                }
                case Warning: {
                    icon = WARNING_ICON;
                    break;
                }
            }
            this.label.setIcon(icon);
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            return ConditionTestPanel.this.taskMonitor.getPreferredSize();
        }

        public ConditionTester getTest() {
            return this.test;
        }

        void setInProgress(boolean inProgress) {
            if (this.inProgress == inProgress) {
                return;
            }
            this.inProgress = inProgress;
            this.removeAll();
            if (inProgress) {
                this.add(ConditionTestPanel.this.taskMonitor);
            } else {
                this.add(this.label);
            }
        }
    }

    private class TestPanel
    extends JPanel {
        private final ConditionTester test;
        private JCheckBox checkbox;
        private JLabel label;
        private Color backgroundColor;
        private Color selectedColor;

        public TestPanel(ConditionTester conditionTest) {
            super((LayoutManager)new PairLayout());
            this.backgroundColor = this.getBackground();
            this.selectedColor = Color.LIGHT_GRAY;
            this.test = conditionTest;
            this.checkbox = new JCheckBox();
            this.checkbox.setSelected(true);
            this.add(this.checkbox);
            this.label = new JLabel(this.test.getName());
            this.add(this.label);
            this.label.setToolTipText(this.test.getDescription());
            this.checkbox.addChangeListener(e -> {
                ConditionTestPanel.this.conditionTestModel.setEnabled(this.test, this.checkbox.isSelected());
                this.label.setEnabled(this.checkbox.isSelected());
            });
            this.label.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!ConditionTestPanel.this.hasRunTests()) {
                        TestPanel.this.checkbox.setSelected(!TestPanel.this.checkbox.isSelected());
                    }
                    ConditionTestPanel.this.selectTest(TestPanel.this.test);
                }
            });
        }

        public void setSelected(ConditionTester selectedTest) {
            boolean isSelected = this.test == selectedTest;
            this.setBackground(isSelected ? this.selectedColor : this.backgroundColor);
        }

        public ConditionTester getTest() {
            return this.test;
        }
    }

    private class OverallProgressBar
    extends JPanel {
        private Color color;
        private int maxProgress;
        private int progress;

        public OverallProgressBar() {
            Border emptyBorder = BorderFactory.createEmptyBorder(10, 15, 10, 5);
            Border bevelBorder = BorderFactory.createBevelBorder(1);
            this.setBorder(BorderFactory.createCompoundBorder(emptyBorder, bevelBorder));
        }

        @Override
        protected void paintComponent(Graphics g) {
            Dimension size = this.getSize();
            Insets insets = this.getInsets();
            int x = insets.left;
            int y = insets.top;
            int width = size.width - insets.left - insets.right;
            int height = size.height - insets.top - insets.bottom;
            g.clearRect(x, y, width, height);
            int fillWidth = (int)((double)this.progress / (double)this.maxProgress * (double)width + 0.5);
            g.setColor(this.color);
            g.fillRect(x, y, fillWidth, height);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(200, 10);
        }

        public void setColor(Color color) {
            this.color = color;
            this.repaint();
        }

        public void setProgress(int progress) {
            if (progress > this.maxProgress) {
                progress = this.maxProgress;
            }
            this.progress = progress;
            this.repaint();
        }

        public void setMaxProgress(int maxProgress) {
            if (maxProgress <= 0) {
                maxProgress = 1;
            }
            this.maxProgress = maxProgress;
            this.repaint();
        }
    }

    private class ScrollableLabel
    extends JLabel
    implements Scrollable {
        private ScrollableLabel() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return new Dimension(200, 100);
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 20;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }
    }
}

